const path = require("path");
const { styles } = require("@ckeditor/ckeditor5-dev-utils");
const HtmlWebpackPlugin = require("html-webpack-plugin");
const MiniCssExtractPlugin = require("mini-css-extract-plugin");

module.exports = {
	// https://webpack.js.org/configuration/entry-context/
	entry: "./demo/app.js",

	// https://webpack.js.org/configuration/output/
	output: {
		path: path.resolve(__dirname, "dist"),
		filename: "bundle.js",
	},

	devServer: {
		disableHostCheck: true,
		headers: {
			"Access-Control-Allow-Origin": "*",
		},
		historyApiFallback: true,
		hot: true,
		inline: true,
		index: "./demo/index.html",
	},

	plugins: [
		new MiniCssExtractPlugin(),
		new HtmlWebpackPlugin({
			template: "./demo/index.html",
		}),
	],

	module: {
		rules: [
			{
				test: /ckeditor5-[^/\\]+[/\\]theme[/\\]icons[/\\][^/\\]+\.svg$/,
				use: ["raw-loader"],
			},
			{
				test: /ckeditor5-[^/\\]+[/\\]theme[/\\].+\.css$/,
				use: [
					MiniCssExtractPlugin.loader,
					"css-loader",
					{
						loader: "postcss-loader",
						options: styles.getPostCssConfig({
							themeImporter: {
								themePath: require.resolve(
									"@ckeditor/ckeditor5-theme-lark"
								),
							},
							minify: true,
						}),
					},
				],
			},
		],
	},

	// Useful for debugging.
	devtool: "source-map",

	// By default webpack logs warnings if the bundle is bigger than 200kb.
	performance: { hints: false },
};
