<?php 
include "connection.php";

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    // Prepare data for insertion
$q_id = uniqid();
$class_id = $data['class'];
$subject_id = $data['subject'];
$chapter_id = $data['chapter'];
$subchapter_id = $data['subChapter'] ?? 0;
$userid = 50;
$subuserid = 0;
$status = 1;
$rate = $data['difficulty'] ?? 0;
$ref = $data['ref'] ?? '';
$year = $data['year'] ?? date('Y');
$board = $data['board'] ?? '';
$mcq_type = $data['questionType'] ?? 1;
$mcq_stamp = $data['stimulus'] ?? '';
$simple_question = $data['question'] ?? '';
$simple_choice_1 = $data['options']['ক'] ?? '';
$simple_choice_2 = $data['options']['খ'] ?? '';
$simple_choice_3 = $data['options']['গ'] ?? '';
$simple_choice_4 = $data['options']['ঘ'] ?? '';
$simple_answer = $data['simple_answer'] ?? '';
$multiple_question = $data['multiplequestion'] ?? '';

$multiple_q_one = $data['multiple_q_one'] ?? '';
$multiple_q_two = $data['multiple_q_two'] ?? '';
$multiple_q_three = $data['multiple_q_three'] ?? '';

$multiple_choice_i = $data['multiple_choice_i'] ?? '';
$multiple_choice_ii = $data['multiple_choice_ii'] ?? '';
$multiple_choice_iii = $data['multiple_choice_iii'] ?? '';
$multiple_choice_iv = $data['multiple_choice_iv'] ?? '';

$multiple_answer = $data['multiple_answer'] ?? '';

$simple_question_other = $data['simple_question_other'] ?? '';
$simple_choice_1_other = $data['simple_choice_1_other'] ?? '';
$simple_choice_2_other = $data['simple_choice_2_other'] ?? '';
$simple_choice_3_other = $data['simple_choice_3_other'] ?? '';
$simple_choice_4_other = $data['simple_choice_4_other'] ?? '';
$simple_answer_other = $data['simple_answer_other'] ?? '';
$other_flag = 0;
$des = $data['explanation'] ?? '';
$created_at = date('Y-m-d H:i:s');

    
    // Create a SQL query with proper escaping
    $sql = "INSERT INTO qb_chapter_mcq (
        q_id, class_id, subject_id, chapter_id, subchapter_id, userid, subuserid, 
        status, rate, ref, year, board, mcq_type, mcq_stamp, simple_question, 
        simple_choice_1, simple_choice_2, simple_choice_3, simple_choice_4, 
        simple_answer, multiple_question, multiple_q_one, multiple_q_two, 
        multiple_q_three, multiple_choice_i, multiple_choice_ii, multiple_choice_iii, 
        multiple_choice_iv, multiple_answer, simple_question_other, 
        simple_choice_1_other, simple_choice_2_other, simple_choice_3_other, 
        simple_choice_4_other, simple_answer_other, other_flag, des, created_at
    ) VALUES (
        '" . $conn->real_escape_string($q_id) . "',
        " . (int)$class_id . ",
        " . (int)$subject_id . ",
        " . (int)$chapter_id . ",
        " . (int)$subchapter_id . ",
        " . (int)$userid . ",
        " . (int)$subuserid . ",
        " . (int)$status . ",
        " . (double)$rate . ",
        '" . $conn->real_escape_string($ref) . "',
        '" . $conn->real_escape_string($year) . "',
        '" . $conn->real_escape_string($board) . "',
        " . (int)$mcq_type . ",
        '" . $conn->real_escape_string($mcq_stamp) . "',
        '" . $conn->real_escape_string($simple_question) . "',
        '" . $conn->real_escape_string($simple_choice_1) . "',
        '" . $conn->real_escape_string($simple_choice_2) . "',
        '" . $conn->real_escape_string($simple_choice_3) . "',
        '" . $conn->real_escape_string($simple_choice_4) . "',
        '" . $conn->real_escape_string($simple_answer) . "',
        '" . $conn->real_escape_string($multiple_question) . "',
        '" . $conn->real_escape_string($multiple_q_one) . "',
        '" . $conn->real_escape_string($multiple_q_two) . "',
        '" . $conn->real_escape_string($multiple_q_three) . "',
        '" . $conn->real_escape_string($multiple_choice_i) . "',
        '" . $conn->real_escape_string($multiple_choice_ii) . "',
        '" . $conn->real_escape_string($multiple_choice_iii) . "',
        '" . $conn->real_escape_string($multiple_choice_iv) . "',
        '" . $conn->real_escape_string($multiple_answer) . "',
        '" . $conn->real_escape_string($simple_question_other) . "',
        '" . $conn->real_escape_string($simple_choice_1_other) . "',
        '" . $conn->real_escape_string($simple_choice_2_other) . "',
        '" . $conn->real_escape_string($simple_choice_3_other) . "',
        '" . $conn->real_escape_string($simple_choice_4_other) . "',
        '" . $conn->real_escape_string($simple_answer_other) . "',
        " . (int)$other_flag . ",
        '" . $conn->real_escape_string($des) . "',
        '" . $conn->real_escape_string($created_at) . "'
    )";
    
    // Execute the query
    if ($conn->query($sql)) {
        echo json_encode(['success' => true, 'message' => 'Question saved successfully']);
    } else {
        echo json_encode([
            'success' => false, 
            'message' => 'Error: ' . $conn->error,
            'sql' => $sql
        ]);
    }
    
    exit;
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Smart Question Management</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/3.2.2/es5/tex-mml-chtml.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <style>
        .rating-container {
            display: flex;
            align-items: center;
        }
        .star {
            cursor: pointer;
            font-size: 24px;
            color: #ccc;
            margin-right: 5px;
        }
        .star.selected {
            color: #ffc107;
        }
        textarea {
            min-height: 120px;
        }
        .form-label {
            font-size: 0.9rem;
            font-weight: 500;
        }
        .form-select, .form-control {
            font-size: 0.9rem;
        }
        .tab-content {
            padding: 20px 0;
        }
        .question-tab {
            background-color: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            transition: all 0.3s ease;
            border-left: 4px solid transparent;
        }
        .question-tab.active {
            border-left: 4px solid #0d6efd;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }
        .nav-tabs .nav-link {
            border-radius: 0;
            transition: all 0.2s ease;
            font-weight: 500;
            font-size: 0.95rem;
            padding: 10px 20px;
        }
        .nav-tabs .nav-link.active {
            border-bottom: 3px solid #0d6efd;
            border-top: none;
            border-left: none;
            border-right: none;
            color: #0d6efd;
            font-weight: bold;
            background-color: transparent;
        }
        .nav-tabs {
            border-bottom: 1px solid #dee2e6;
        }
        .section-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 15px;
            color: #495057;
        }
        .question-form-divider {
            margin: 15px 0;
            border-top: 1px dashed #dee2e6;
        }
    </style>
</head>
<body>
<div class="container mt-4 mb-5">
  <div class="card">
    <div class="card-header bg-white py-3">
      <h2 class="m-0 font-weight-bold text-primary text-center">Smart Question Management</h2>
    </div>
    <div class="card-body">
      <!-- Form Start -->
      <form id="question-form">
        <div class="form-section active" id="section-1">
          <div class="row">
            <!-- Left Column - Selection Options -->
            <div class="col-md-6">
              <!-- Entity -->
              <div class="mb-3">
                <label for="entity-select" class="form-label">এনটিটি নির্বাচন করুন:</label>
                <select class="form-select" id="entity-select" required>
                  <option value="">-- এনটিটি নির্বাচন করুন --</option>
                  <?php
              $sql = "SELECT * FROM qb_entity WHERE is_active=1";
              $result = $conn->query($sql);
              if ($result->num_rows > 0) {
                  while ($row = $result->fetch_assoc()) {
                      echo '<option value="' . $row["id"] . '">' . $row["entity_name"] . '</option>';
                  }
              }
              ?>
                </select>
              </div>

              <div class="mb-3">
                <label class="form-label">ক্লাস নির্বাচন করুন:</label>
                <select class="form-select" id="class-select" required>
                  <option value="">-- ক্লাস নির্বাচন করুন --</option>
                </select>
              </div>

              <div class="mb-3">
                <label class="form-label">বিষয় নির্বাচন করুন:</label>
                <select class="form-select" id="subject-select" required>
                  <option value="">-- বিষয় নির্বাচন করুন --</option>
                </select>
              </div>

              <div class="mb-3">
                <label class="form-label">অধ্যায় নির্বাচন করুন:</label>
                <select class="form-select" id="chapter-select">
                  <option value="">-- অধ্যায় নির্বাচন করুন --</option>
                </select>
              </div>

              <div class="mb-3">
                <label class="form-label">উপ অধ্যায় নির্বাচন করুন:</label>
                <select class="form-select" id="subChapter-select">
                  <option value="">-- উপ অধ্যায় নির্বাচন করুন --</option>
                </select>
              </div>
            </div>

            <!-- Right Column - Additional Info -->
            <div class="col-md-6">
              <div class="mb-3">
                <label class="form-label">বছর নির্বাচন করুন:</label>
                <select class="form-select" id="year-select" >
                  <option value="">-- বছর নির্বাচন করুন --</option>
                  <?php for ($y = 2025; $y >= 2016; $y--) echo "<option value='$y'>$y</option>"; ?>
                </select>
              </div>

              <div class="mb-3">
  <label class="form-label">বোর্ড নির্বাচন করুন:</label>
  <select class="form-select" id="board-select" >
    <option value="">-- বোর্ড নির্বাচন করুন --</option>
    <option value="Dhaka">ঢাকা বোর্ড</option>
    <option value="Rajshahi">রাজশাহী বোর্ড</option>
    <option value="Chittagong">চট্টগ্রাম বোর্ড</option>
    <option value="Khulna">খুলনা বোর্ড</option>
    <option value="Barisal">বরিশাল বোর্ড</option>
    <option value="Sylhet">সিলেট বোর্ড</option>
    <option value="Comilla">কুমিল্লা বোর্ড</option>
    <option value="Jessore">যশোর বোর্ড</option>
    <option value="Dinajpur">দিনাজপুর বোর্ড</option>
    <option value="Mymensingh">ময়মনসিংহ বোর্ড</option>
    <option value="Madrasah">মাদ্রাসা বোর্ড</option>
    <option value="Technical">কারিগরি বোর্ড</option>
  </select>
</div>


              <div class="mb-3">
                <label class="form-label">প্রশ্নের কঠিনতা স্তর:</label>
                <div class="rating-container">
                  <span class="star" data-rating="1"><i class="fas fa-star"></i></span>
                  <span class="star" data-rating="2"><i class="fas fa-star"></i></span>
                  <span class="star" data-rating="3"><i class="fas fa-star"></i></span>
                  <span class="star" data-rating="4"><i class="fas fa-star"></i></span>
                  <span class="star" data-rating="5"><i class="fas fa-star"></i></span>
                  <span class="ms-2" id="rating-text">এখনো নির্ধারণ করা হয়নি</span>
                </div>
              </div>

              <div class="mb-3">
                <label class="form-label">ব্যাখ্যা লিখুন:</label>
                <textarea class="form-control" id="explanation-input" rows="2" placeholder="এখানে ব্যাখ্যা লিখুন..."></textarea>
              </div>
              <div class="mb-3">
                <label class="form-label">রেফারেন্স:</label>
                <textarea class="form-control" id="ref" rows="1" placeholder="এখানে রেফারেন্স লিখুন..."></textarea>
              </div>
            </div>
          </div>

          <!-- Question Type Navigation Tabs -->
          <div class="mt-4">
            <div class="mb-3">
              <label class="form-label">প্রশ্নের ধরন নির্বাচন করুন:</label>
              <select class="form-select mb-3" id="question-type-select" required>
                <option value="">-- প্রশ্নের ধরন নির্বাচন করুন --</option>
                <option value="1">সাধারণ বহুনির্বাচনী</option>
                <option value="2">বহুপদী বহুনির্বাচনী</option>
                <option value="3">অতিরিক্ত বহুনির্বাচনী</option>
              </select>
              
              <ul class="nav nav-tabs" id="questionTabs" role="tablist">
                <li class="nav-item" role="presentation">
                  <button class="nav-link active" id="simple-tab" data-bs-toggle="tab" data-bs-target="#simple-questions" type="button" role="tab" aria-controls="simple-questions" aria-selected="true">
                    <i class="fas fa-question-circle me-1"></i> সাধারণ প্রশ্ন
                  </button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="multiple-tab" data-bs-toggle="tab" data-bs-target="#multiple-questions" type="button" role="tab" aria-controls="multiple-questions" aria-selected="false">
                    <i class="fas fa-list-ol me-1"></i> বহুনির্বাচনী প্রশ্ন
                  </button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="additional-tab" data-bs-toggle="tab" data-bs-target="#additional-questions" type="button" role="tab" aria-controls="additional-questions" aria-selected="false">
                    <i class="fas fa-plus-circle me-1"></i> অতিরিক্ত প্রশ্ন
                  </button>
                </li>
              </ul>
            </div>

            <div class="tab-content" id="questionTabsContent">
              <!-- সাধারণ প্রশ্ন Tab -->
              <div class="tab-pane fade show active" id="simple-questions" role="tabpanel" aria-labelledby="simple-tab">
                <div class="question-tab active">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="mb-3">
                        <label class="form-label">উদ্দীপক লিখুন:</label>
                        <textarea class="form-control" id="stimulus-input" rows="3" placeholder="এখানে উদ্দীপক লিখুন..."></textarea>
                      </div>
                      
                      <div class="mb-3">
                        <label class="form-label">প্রশ্ন লিখুন:</label>
                        <textarea class="form-control" id="question-input" rows="3" placeholder="এখানে প্রশ্ন লিখুন..."></textarea>
                      </div>
                    </div>
                  </div>
                  
                  <div class="row">
                    <div class="col-md-6">
                      <div class="mb-2">
                        <label class="form-label">উত্তর বিকল্প:</label>
                        <input type="text" id="option-a" class="form-control mb-2" placeholder="বিকল্প ১ লিখুন..." required>
                        <input type="text" id="option-b" class="form-control mb-2" placeholder="বিকল্প ২ লিখুন..." required>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-2">
                        <label class="form-label">&nbsp;</label>
                        <input type="text" id="option-c" class="form-control mb-2" placeholder="বিকল্প ৩ লিখুন..." required>
                        <input type="text" id="option-d" class="form-control mb-2" placeholder="বিকল্প ৪ লিখুন..." required>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">সঠিক উত্তর:</label>
                        <select class="form-control" id="simple_answer">
                          <option value="">-- সঠিক উত্তর নির্বাচন করুন --</option>
                          <option value="1">১</option>
                          <option value="2">২</option>
                          <option value="3">৩</option>
                          <option value="4">৪</option>
                        </select>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- বহুনির্বাচনী প্রশ্ন Tab -->
              <div class="tab-pane fade" id="multiple-questions" role="tabpanel" aria-labelledby="multiple-tab">
                <div class="question-tab">
                  <div class="mb-3">
                    <label class="form-label">বহুনির্বাচনী প্রশ্ন লিখুন:</label>
                    <textarea class="form-control" id="multiplequestion-input" rows="3" placeholder="এখানে প্রশ্ন লিখুন..."></textarea>
                  </div>
                  
                  <div class="row">
                    <div class="col-md-6">
                      <!-- প্রশ্ন সেকশন -->
                      <div class="mb-3">
                        <label class="form-label">প্রশ্ন লিখুন:</label>
                        <input type="text" class="form-control" id="multiple_q_one" placeholder="প্রশ্ন ১ লিখুন">
                      </div>
                      <div class="mb-3">
                        <input type="text" class="form-control" id="multiple_q_two" placeholder="প্রশ্ন ২ লিখুন">
                      </div>
                      <div class="mb-3">
                        <input type="text" class="form-control" id="multiple_q_three" placeholder="প্রশ্ন ৩ লিখুন">
                      </div>
                    </div>
                    
                    <div class="col-md-6">
                      <!-- বিকল্প সেকশন -->
                      <div class="mb-3">
                        <label class="form-label">বিকল্প i, ii, iii, iv:</label>
                        <input type="text" class="form-control" id="multiple_choice_i" placeholder="বিকল্প ১ লিখুন">
                      </div>
                      <div class="mb-3">
                        <input type="text" class="form-control" id="multiple_choice_ii" placeholder="বিকল্প ২ লিখুন">
                      </div>
                      <div class="mb-3">
                        <input type="text" class="form-control" id="multiple_choice_iii" placeholder="বিকল্প ৩ লিখুন">
                      </div>
                      <div class="mb-3">
                        <input type="text" class="form-control" id="multiple_choice_iv" placeholder="বিকল্প ৪ লিখুন">
                      </div>
                    </div>
                    
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">সঠিক উত্তর:</label>
                        <select class="form-control" id="multiple_answer">
                          <option value="">-- সঠিক উত্তর নির্বাচন করুন --</option>
                          <option value="1">১</option>
                          <option value="2">২</option>
                          <option value="3">৩</option>
                          <option value="4">৪</option>
                        </select>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- অতিরিক্ত প্রশ্ন Tab -->
              <div class="tab-pane fade" id="additional-questions" role="tabpanel" aria-labelledby="additional-tab">
                <div class="question-tab">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="mb-3">
                        <label class="form-label">অতিরিক্ত প্রশ্ন:</label>
                        <textarea class="form-control" id="simple_question_other" rows="3" placeholder="এখানে অতিরিক্ত প্রশ্ন লিখুন..."></textarea>
                      </div>
                    </div>
                  </div>
                  
                  <div class="row">
                    <div class="col-md-6">
                      <div class="mb-2">
                        <input type="text" id="simple_choice_1_other" class="form-control mb-2" placeholder="অতিরিক্ত বিকল্প ১ লিখুন...">
                        <input type="text" id="simple_choice_2_other" class="form-control mb-2" placeholder="অতিরিক্ত বিকল্প ২ লিখুন...">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-2">
                        <input type="text" id="simple_choice_3_other" class="form-control mb-2" placeholder="অতিরিক্ত বিকল্প ৩ লিখুন...">
                        <input type="text" id="simple_choice_4_other" class="form-control mb-2" placeholder="অতিরিক্ত বিকল্প ৪ লিখুন...">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="mb-3">
                        <label class="form-label">সঠিক অতিরিক্ত উত্তর:</label>
                        <select class="form-control" id="simple_answer_other">
                          <option value="">-- সঠিক উত্তর নির্বাচন করুন --</option>
                          <option value="1">১</option>
                          <option value="2">২</option>
                          <option value="3">৩</option>
                          <option value="4">৪</option>
                        </select>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="mt-4 d-flex justify-content-between">
          <a href="index.php" class="btn btn-success">হোম পেজ</a>
            <button type="button" class="btn btn-success" onclick="submitData()">
              <i class="fas fa-save me-1"></i> প্রশ্ন জমা দিন
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Success Modal -->
<div class="modal fade" id="successModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">
          <i class="fas fa-check-circle me-2"></i> সফল
        </h5>
      </div>
      <div class="modal-body">প্রশ্নটি সফলভাবে জমা হয়েছে!</div>
      <div class="modal-footer">
        <button type="button" class="btn btn-success" data-bs-dismiss="modal">হোম পেইজে যান</button>
      </div>
    </div>
  </div>
</div>


<!-- Error Modal -->
<div class="modal fade" id="errorModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title"><i class="fas fa-exclamation-triangle me-2"></i> ত্রুটি</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="error-message">ত্রুটি ঘটেছে।</div>
    </div>
  </div>
</div>

<script>
// Initialize tabs
document.addEventListener('DOMContentLoaded', function() {
  // Activate question tabs
  var triggerTabList = [].slice.call(document.querySelectorAll('#questionTabs button'))
  triggerTabList.forEach(function (triggerEl) {
    triggerEl.addEventListener('click', function (event) {
      event.preventDefault();
      
      // Update active tab styling
      document.querySelectorAll('.question-tab').forEach(function(tab) {
        tab.classList.remove('active');
      });
      
      // Find and activate the corresponding question tab
      var targetId = this.getAttribute('data-bs-target');
      var targetPane = document.querySelector(targetId);
      if (targetPane) {
        targetPane.querySelector('.question-tab').classList.add('active');
      }
    });
  });
  
  // Handle star rating
  var stars = document.querySelectorAll('.star');
  stars.forEach(function(star) {
    star.addEventListener('click', function() {
      var rating = this.getAttribute('data-rating');
      updateRating(rating);
    });
  });

  function updateRating(rating) {
    stars.forEach(function(s) {
      if (s.getAttribute('data-rating') <= rating) {
        s.classList.add('selected');
      } else {
        s.classList.remove('selected');
      }
    });
    document.getElementById('rating-text').textContent = 'কঠিনতা: ' + rating + '/5';
  }
});
</script>
</body>
<script>
document.getElementById('entity-select').addEventListener('change', function () {
    var entityId = this.value;
    var classSelect = document.getElementById('class-select');
    classSelect.innerHTML = '<option value="">লোড হচ্ছে...</option>';

    fetch('get_classes.php?entity_id=' + entityId)
        .then(response => response.json())
        .then(data => {
            classSelect.innerHTML = '<option value="">-- ক্লাস নির্বাচন করুন --</option>';
            data.forEach(item => {
                classSelect.innerHTML += `<option value="${item.id}">${item.Name}</option>`;
            });
        })
        .catch(error => {
            console.error('Error:', error);
            classSelect.innerHTML = '<option value="">লোড করতে ব্যর্থ হয়েছে</option>';
        });
});

document.getElementById('class-select').addEventListener('change', function () {
    var classId = this.value;
    console.log('Selected class_id:', classId);
    var subjectSelect = document.getElementById('subject-select');
    subjectSelect.innerHTML = '<option value="">লোড হচ্ছে...</option>';

    if (!classId) {
        subjectSelect.innerHTML = '<option value="">-- প্রথমে একটি শ্রেণী নির্বাচন করুন --</option>';
        return;
    }

    fetch('get_subjects.php?class_id=' + classId)
        .then(response => response.json())
        .then(data => {
            console.log('Subjects data:', data);
            subjectSelect.innerHTML = '<option value="">-- বিষয় নির্বাচন করুন --</option>';
            if (data.length === 0) {
                subjectSelect.innerHTML += '<option value="">কোনো বিষয় পাওয়া যায়নি</option>';
            } else {
                data.forEach(item => {
                    subjectSelect.innerHTML += `<option value="${item.id}">${item.name}</option>`;
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            subjectSelect.innerHTML = '<option value="">লোড করতে ব্যর্থ হয়েছে</option>';
        });
});

document.getElementById('subject-select').addEventListener('change', function () {
    var subjectId = this.value;
    console.log('Selected subject_id:', subjectId);
    var chapterSelect = document.getElementById('chapter-select');
    chapterSelect.innerHTML = '<option value="">লোড হচ্ছে...</option>';

    if (!subjectId) {
        chapterSelect.innerHTML = '<option value="">-- প্রথমে একটি বিষয় নির্বাচন করুন --</option>';
        return;
    }

    fetch('get_chapters.php?subject_id=' + subjectId)
        .then(response => response.json())
        .then(data => {
            console.log('Chapters data:', data);
            chapterSelect.innerHTML = '<option value="">-- অধ্যায় নির্বাচন করুন --</option>';
            if (data.length === 0) {
                chapterSelect.innerHTML += '<option value="">কোনো অধ্যায় পাওয়া যায়নি</option>';
            } else {
                data.forEach(item => {
                    chapterSelect.innerHTML += `<option value="${item.id}">${item.chapter_name}</option>`;
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            chapterSelect.innerHTML = '<option value="">লোড করতে ব্যর্থ হয়েছে</option>';
        });
});

document.getElementById('chapter-select').addEventListener('change', function () {
    var chapterId = this.value;
    console.log('Selected chapter_id:', chapterId);
    var subChapterSelect = document.getElementById('subChapter-select');
    subChapterSelect.innerHTML = '<option value="">লোড হচ্ছে...</option>';

    if (!chapterId) {
        subChapterSelect.innerHTML = '<option value="">-- প্রথমে একটি অধ্যায় নির্বাচন করুন --</option>';
        return;
    }

    fetch('get_subchapters.php?chapter_id=' + chapterId)
        .then(response => response.json())
        .then(data => {
            console.log('Subchapters data:', data);
            subChapterSelect.innerHTML = '<option value="">-- উপ অধ্যায় নির্বাচন করুন --</option>';
            if (data.length === 0) {
                subChapterSelect.innerHTML += '<option value="">কোনো উপ অধ্যায় পাওয়া যায়নি</option>';
            } else {
                data.forEach(item => {
                    subChapterSelect.innerHTML += `<option value="${item.id}">${item.sub_chapter_name}</option>`;
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            subChapterSelect.innerHTML = '<option value="">লোড করতে ব্যর্থ হয়েছে</option>';
        });
});

document.querySelectorAll('.star').forEach(star => {
  star.addEventListener('click', function () {
    document.querySelectorAll('.star').forEach(s => s.classList.remove('selected'));
    this.classList.add('selected');
    document.getElementById('rating-text').textContent = `আপনার রেটিং: ${this.dataset.rating}`;
  });
});

function validateForm() {
  const requiredFields = [
    { id: 'entity-select', name: 'এনটিটি' },
    { id: 'class-select', name: 'ক্লাস' },
    { id: 'subject-select', name: 'বিষয়' },
    { id: 'chapter-select', name: 'অধ্যায়' },
    { id: 'question-type-select', name: 'প্রশ্নের ধরন' },
    { id: 'question-input', name: 'প্রশ্ন' },
    { id: 'option-a', name: 'বিকল্প (ক)' },
    { id: 'option-b', name: 'বিকল্প (খ)' },
    { id: 'option-c', name: 'বিকল্প (গ)' },
    { id: 'option-d', name: 'বিকল্প (ঘ)' },
  ];

  for (const field of requiredFields) {
    const element = document.getElementById(field.id);
    if (!element.value.trim()) {
      showError(`${field.name} অবশ্যই পূরণ করতে হবে।`);
      element.focus();
      return false;
    }
  }



  return true;
}

function submitData() {
  if (!validateForm()) return;
  const data = {
  entity: document.getElementById('entity-select').value,
  class: document.getElementById('class-select').value,
  subject: document.getElementById('subject-select').value,
  chapter: document.getElementById('chapter-select').value,
  subChapter: document.getElementById('subChapter-select').value,
  questionType: document.getElementById('question-type-select').value,
  stimulus: document.getElementById('stimulus-input').value,
  question: document.getElementById('question-input').value,
  multiplequestion: document.getElementById('multiplequestion-input').value,
  
  // Extra multiple questions
  multiple_q_one: document.getElementById('multiple_q_one').value,
  multiple_q_two: document.getElementById('multiple_q_two').value,
  multiple_q_three: document.getElementById('multiple_q_three').value,

  // Multiple choice options
  multiple_choice_i: document.getElementById('multiple_choice_i').value,
  multiple_choice_ii: document.getElementById('multiple_choice_ii').value,
  multiple_choice_iii: document.getElementById('multiple_choice_iii').value,
  multiple_choice_iv: document.getElementById('multiple_choice_iv').value,

  // Correct answer from dropdown
  multiple_answer: document.getElementById('multiple_answer').value,
  simple_answer: document.getElementById('simple_answer').value,

  simple_question_other: document.getElementById('simple_question_other').value,
    simple_choice_1_other: document.getElementById('simple_choice_1_other').value,
    simple_choice_2_other: document.getElementById('simple_choice_2_other').value,
    simple_choice_3_other: document.getElementById('simple_choice_3_other').value,
    simple_choice_4_other: document.getElementById('simple_choice_4_other').value,
    simple_answer_other: document.getElementById('simple_answer_other').value,
    ref: document.getElementById('ref').value,

  explanation: document.getElementById('explanation-input').value,
  options: {
    ক: document.getElementById('option-a').value,
    খ: document.getElementById('option-b').value,
    গ: document.getElementById('option-c').value,
    ঘ: document.getElementById('option-d').value
  },
  year: document.getElementById('year-select').value,
  board: document.getElementById('board-select').value,
  difficulty: document.querySelector('.star.selected')?.dataset.rating || 0
};


fetch('', {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(data)
  })
  .then(res => res.json())
  .then(res => {
    if (res.success) {
      // Show the success modal
      $('#successModal').modal('show');

      // Reset the form
      document.getElementById('question-form').reset();
      document.querySelectorAll('.star').forEach(s => s.classList.remove('selected'));
      document.getElementById('rating-text').textContent = "এখনো নির্ধারণ করা হয়নি";

      // Redirect to index.php when modal is closed
      $('#successModal').on('hidden.bs.modal', function () {
        window.location.href = 'index.php';
      });

    } else {
      showError(res.message || 'জমা দিতে ব্যর্থ হয়েছে।');
    }
  })
  .catch(err => {
    console.error(err);
    showError('সার্ভার সমস্যার কারণে সংরক্ষণ ব্যর্থ হয়েছে।');
  });
}

function showError(msg) {
  document.getElementById('error-message').textContent = msg;
  $('#errorModal').modal('show');
}
</script>
</body>
</html>