<?php
// Include database connection
include 'connection.php';

// Check if ID parameter exists
if (!isset($_GET['id']) || empty($_GET['id'])) {
    // Redirect to index page with error message
    header('Location: index.php?error=No question ID specified');
    exit;
}

// Get and sanitize the ID
$id = intval($_GET['id']);
$id = $conn->real_escape_string($id);

// Check if the form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize and get form data
    $simple_question = $conn->real_escape_string($_POST['simple_question']);
    $simple_choice_1 = $conn->real_escape_string($_POST['simple_choice_1']);
    $simple_choice_2 = $conn->real_escape_string($_POST['simple_choice_2']);
    $simple_choice_3 = $conn->real_escape_string($_POST['simple_choice_3']);
    $simple_choice_4 = $conn->real_escape_string($_POST['simple_choice_4']);
    $simple_answer = $conn->real_escape_string($_POST['simple_answer']);
    
    // New fields
    $multiple_question = $conn->real_escape_string($_POST['multiple_question']);
    $multiple_q_one = $conn->real_escape_string($_POST['multiple_q_one']);
    $multiple_q_two = $conn->real_escape_string($_POST['multiple_q_two']);
    $multiple_q_three = $conn->real_escape_string($_POST['multiple_q_three']);
    $multiple_choice_i = $conn->real_escape_string($_POST['multiple_choice_i']);
    $multiple_choice_ii = $conn->real_escape_string($_POST['multiple_choice_ii']);
    $multiple_choice_iii = $conn->real_escape_string($_POST['multiple_choice_iii']);
    $multiple_choice_iv = $conn->real_escape_string($_POST['multiple_choice_iv']);
    $multiple_answer = $conn->real_escape_string($_POST['multiple_answer']);
    
    // Added "other" variants
    $simple_question_other = $conn->real_escape_string($_POST['simple_question_other']);
    $simple_choice_1_other = $conn->real_escape_string($_POST['simple_choice_1_other']);
    $simple_choice_2_other = $conn->real_escape_string($_POST['simple_choice_2_other']);
    $simple_choice_3_other = $conn->real_escape_string($_POST['simple_choice_3_other']);
    $simple_choice_4_other = $conn->real_escape_string($_POST['simple_choice_4_other']);
    $simple_answer_other = $conn->real_escape_string($_POST['simple_answer_other']);
    $other_flag = isset($_POST['other_flag']) ? $conn->real_escape_string($_POST['other_flag']) : '0';
    $mcq_stamp = $conn->real_escape_string($_POST['mcq_stamp']);
    
    // Update query with updated_at timestamp
    $updateSql = "UPDATE qb_chapter_mcq SET 
        simple_question = '$simple_question',
        simple_choice_1 = '$simple_choice_1',
        simple_choice_2 = '$simple_choice_2',
        simple_choice_3 = '$simple_choice_3',
        simple_choice_4 = '$simple_choice_4',
        simple_answer = '$simple_answer',
        multiple_question = '$multiple_question',
        multiple_q_one = '$multiple_q_one',
        multiple_q_two = '$multiple_q_two',
        multiple_q_three = '$multiple_q_three',
        multiple_choice_i = '$multiple_choice_i',
        multiple_choice_ii = '$multiple_choice_ii',
        multiple_choice_iii = '$multiple_choice_iii',
        multiple_choice_iv = '$multiple_choice_iv',
        multiple_answer = '$multiple_answer',
        simple_question_other = '$simple_question_other',
        simple_choice_1_other = '$simple_choice_1_other',
        simple_choice_2_other = '$simple_choice_2_other',
        simple_choice_3_other = '$simple_choice_3_other',
        simple_choice_4_other = '$simple_choice_4_other',
        simple_answer_other = '$simple_answer_other',
        other_flag = '$other_flag',
        mcq_stamp = '$mcq_stamp'
    WHERE id = '$id'";
    
    if ($conn->query($updateSql)) {
        // Success, redirect to index
        header('Location: index.php?success=Question updated successfully');
        exit;
    } else {
        // Error
        $error = "Error updating question: " . $conn->error;
    }
}

// Query to fetch question details to display in the form
$sql = "SELECT 
    qm.*,
    c.name as class_name,
    s.name as subject_name,
    ch.chapter_name
FROM 
    qb_chapter_mcq qm
LEFT JOIN 
    qb_classes c ON qm.class_id = c.id
LEFT JOIN 
    qb_subjects s ON qm.subject_id = s.id
LEFT JOIN 
    qb_chapters ch ON qm.chapter_id = ch.id
WHERE 
    qm.id = '$id'";

$result = $conn->query($sql);

if ($result->num_rows === 0) {
    // Question doesn't exist
    header('Location: index.php?error=Question not found');
    exit;
}

$question = $result->fetch_assoc();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Question - Smart Question Management System</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #3a7bd5;
            --primary-dark: #2c62b5;
            --secondary-color: #00d2ff;
            --accent-color: #f8f9fa;
            --success-color: #28a745;
            --warning-color: #ffc107;
            --danger-color: #dc3545;
        }
        
        body {
            background-color: #f0f2f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }
        
        .container {
            max-width: 1100px;
            padding-top: 2rem;
            padding-bottom: 2rem;
        }
        
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            padding: 1.5rem 2rem;
            border-radius: 12px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
        }
        
        .header-container h1 {
            color: white;
            margin: 0;
            font-weight: 600;
            font-size: 1.8rem;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
        }
        
        .card {
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            border: none;
            overflow: hidden;
        }
        
        .card-header {
            background: linear-gradient(to right, var(--primary-color), var(--primary-dark));
            border-bottom: none;
            color: white;
            padding: 1rem 1.5rem;
            font-weight: 500;
        }
        
        .card-body {
            padding: 1.5rem;
        }
        
        .question-info {
            background-color: rgba(58, 123, 213, 0.05);
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .info-item {
            margin-bottom: 8px;
            display: flex;
        }
        
        .info-label {
            font-weight: 600;
            width: 120px;
            color: var(--primary-dark);
        }
        
        .info-value {
            flex: 1;
        }
        
        .required-field::after {
            content: " *";
            color: var(--danger-color);
        }
        
        .form-label {
            font-weight: 500;
            color: #555;
        }
        
        .form-control, .form-select {
            border-radius: 8px;
            border: 1px solid #ced4da;
            padding: 0.6rem 1rem;
            transition: all 0.3s;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(58, 123, 213, 0.25);
        }
        
        textarea.form-control {
            min-height: 60px;
        }
        
        .btn {
            border-radius: 8px;
            padding: 0.6rem 1.2rem;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .btn-primary:hover {
            background-color: var(--primary-dark);
            border-color: var(--primary-dark);
        }
        
        .btn-success {
            background-color: var(--success-color);
            border-color: var(--success-color);
        }
        
        .btn-success:hover {
            background-color: #218838;
            border-color: #1e7e34;
        }
        
        .btn-light {
            background-color: white;
            border-color: #ddd;
            color: var(--primary-color);
        }
        
        .btn-light:hover {
            background-color: #f8f9fa;
            border-color: #ddd;
            color: var(--primary-dark);
        }
        
        .nav-tabs .nav-link {
            border-radius: 8px 8px 0 0;
            font-weight: 500;
            color: #555;
            padding: 0.75rem 1.5rem;
            transition: all 0.3s;
            border: 1px solid transparent;
        }
        
        .nav-tabs .nav-link.active {
            background: linear-gradient(to right, var(--primary-color), var(--primary-dark));
            color: white;
            border-color: transparent;
        }
        
        .nav-tabs .nav-link:hover:not(.active) {
            background-color: rgba(58, 123, 213, 0.1);
            border-color: transparent;
        }
        
        .tab-content {
            background-color: white;
            border-radius: 0 0 8px 8px;
            padding: 20px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }
        
        .tab-pane {
            padding: 15px 0;
        }
        
        .form-section {
            padding: 15px;
            background-color: rgba(58, 123, 213, 0.03);
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .section-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--primary-dark);
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid rgba(58, 123, 213, 0.2);
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="header-container">
            <h1><i class="fas fa-edit me-2"></i>Edit Question</h1>
            <a href="index.php" class="btn btn-light">
                <i class="fas fa-arrow-left me-2"></i>Back to List
            </a>
        </div>

        <?php if (isset($error)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i><?php echo $error; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Question Details</h5>
            </div>
            <div class="card-body">
                <!-- Question Info (Read Only) -->
                <div class="question-info">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-item">
                                <span class="info-label">Question ID:</span>
                                <span class="info-value"><?php echo $id; ?></span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">Class:</span>
                                <span class="info-value"><?php echo htmlspecialchars($question['class_name'] ?? 'N/A'); ?></span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">Subject:</span>
                                <span class="info-value"><?php echo htmlspecialchars($question['subject_name'] ?? 'N/A'); ?></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-item">
                                <span class="info-label">Chapter:</span>
                                <span class="info-value"><?php echo htmlspecialchars($question['chapter_name'] ?? 'N/A'); ?></span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">MCQ Type:</span>
                                <span class="info-value">
                                    <?php 
                                    switch($question['mcq_type']) {
                                        case '1': echo 'Simple MCQ'; break;
                                        case '2': echo 'Complex MCQ'; break;
                                        case '3': echo 'Common Data Based'; break;
                                        default: echo 'N/A';
                                    }
                                    ?>
                                </span>
                            </div>
                            <div class="info-item">
                                <span class="info-label">Difficulty:</span>
                                <span class="info-value">
                                    <?php 
                                    switch($question['rate']) {
                                        case '1': echo 'Easy'; break;
                                        case '2': echo 'Medium'; break;
                                        case '3': echo 'Hard'; break;
                                        default: echo 'N/A';
                                    }
                                    ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <form method="post" action="">
                    <!-- Added mcq_stamp field -->
                    <div class="mb-3">
                        <label for="mcq_stamp" class="form-label">MCQ উদ্দীপক</label>
                        <input type="text" class="form-control" id="mcq_stamp" name="mcq_stamp" 
                               value="<?php echo htmlspecialchars($question['mcq_stamp'] ?? ''); ?>">
                    </div>

                    <!-- Other Flag Option -->
                    <div class="mb-3">
                        <label for="other_flag" class="form-label">Other Flag</label>
                        <select class="form-select" id="other_flag" name="other_flag">
                            <option value="0" <?php echo ($question['other_flag'] == '0' || empty($question['other_flag'])) ? 'selected' : ''; ?>>No</option>
                            <option value="1" <?php echo ($question['other_flag'] == '1') ? 'selected' : ''; ?>>Yes</option>
                        </select>
                    </div>

                    <!-- Tabs for different question types -->
                    <ul class="nav nav-tabs mt-4" id="questionTypeTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="simple-tab" data-bs-toggle="tab" data-bs-target="#simple" type="button" role="tab" aria-selected="true">
                                <i class="fas fa-question-circle me-2"></i>Simple MCQ
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="multiple-tab" data-bs-toggle="tab" data-bs-target="#multiple" type="button" role="tab" aria-selected="false">
                                <i class="fas fa-tasks me-2"></i>Complex MCQ
                            </button>
                        </li>
                        
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="other-tab" data-bs-toggle="tab" data-bs-target="#other" type="button" role="tab" aria-selected="false">
                                <i class="fas fa-plus-circle me-2"></i>Alternative Version
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content" id="questionTypeContent">
                        <!-- Simple MCQ Content -->
                        <div class="tab-pane fade show active" id="simple" role="tabpanel" aria-labelledby="simple-tab">
                            <div class="form-section">
                                <div class="section-title">Simple Question Details</div>
                                
                                <div class="mb-3">
                                    <label for="simple_question" class="form-label">Question</label>
                                    <textarea class="form-control" id="simple_question" name="simple_question" rows="4"><?php echo htmlspecialchars($question['simple_question'] ?? ''); ?></textarea>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="simple_choice_1" class="form-label">Option 1</label>
                                        <textarea class="form-control" id="simple_choice_1" name="simple_choice_1" rows="2"><?php echo htmlspecialchars($question['simple_choice_1'] ?? ''); ?></textarea>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="simple_choice_2" class="form-label">Option 2</label>
                                        <textarea class="form-control" id="simple_choice_2" name="simple_choice_2" rows="2"><?php echo htmlspecialchars($question['simple_choice_2'] ?? ''); ?></textarea>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="simple_choice_3" class="form-label">Option 3</label>
                                        <textarea class="form-control" id="simple_choice_3" name="simple_choice_3" rows="2"><?php echo htmlspecialchars($question['simple_choice_3'] ?? ''); ?></textarea>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="simple_choice_4" class="form-label">Option 4</label>
                                        <textarea class="form-control" id="simple_choice_4" name="simple_choice_4" rows="2"><?php echo htmlspecialchars($question['simple_choice_4'] ?? ''); ?></textarea>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="simple_answer" class="form-label">Correct Answer</label>
                                    <textarea class="form-control" id="simple_answer" name="simple_answer" rows="2"><?php echo htmlspecialchars($question['simple_answer'] ?? ''); ?></textarea>
                                    <div class="form-text">Enter the correct answer text, which should match one of the options above.</div>
                                </div>
                            </div>
                        </div>

                        <!-- Multiple/Complex MCQ Content -->
                        <div class="tab-pane fade" id="multiple" role="tabpanel" aria-labelledby="multiple-tab">
                            <div class="form-section">
                                <div class="section-title">Complex Question Details</div>
                                
                                <div class="mb-3">
                                    <label for="multiple_question" class="form-label">Main Question</label>
                                    <textarea class="form-control" id="multiple_question" name="multiple_question" rows="4"><?php echo htmlspecialchars($question['multiple_question'] ?? ''); ?></textarea>
                                </div>

                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label for="multiple_q_one" class="form-label">Sub Question 1</label>
                                        <textarea class="form-control" id="multiple_q_one" name="multiple_q_one" rows="2"><?php echo htmlspecialchars($question['multiple_q_one'] ?? ''); ?></textarea>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="multiple_q_two" class="form-label">Sub Question 2</label>
                                        <textarea class="form-control" id="multiple_q_two" name="multiple_q_two" rows="2"><?php echo htmlspecialchars($question['multiple_q_two'] ?? ''); ?></textarea>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="multiple_q_three" class="form-label">Sub Question 3</label>
                                        <textarea class="form-control" id="multiple_q_three" name="multiple_q_three" rows="2"><?php echo htmlspecialchars($question['multiple_q_three'] ?? ''); ?></textarea>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="multiple_choice_i" class="form-label">Option I</label>
                                        <textarea class="form-control" id="multiple_choice_i" name="multiple_choice_i" rows="2"><?php echo htmlspecialchars($question['multiple_choice_i'] ?? ''); ?></textarea>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="multiple_choice_ii" class="form-label">Option II</label>
                                        <textarea class="form-control" id="multiple_choice_ii" name="multiple_choice_ii" rows="2"><?php echo htmlspecialchars($question['multiple_choice_ii'] ?? ''); ?></textarea>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="multiple_choice_iii" class="form-label">Option III</label>
                                        <textarea class="form-control" id="multiple_choice_iii" name="multiple_choice_iii" rows="2"><?php echo htmlspecialchars($question['multiple_choice_iii'] ?? ''); ?></textarea>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="multiple_choice_iv" class="form-label">Option IV</label>
                                        <textarea class="form-control" id="multiple_choice_iv" name="multiple_choice_iv" rows="2"><?php echo htmlspecialchars($question['multiple_choice_iv'] ?? ''); ?></textarea>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="multiple_answer" class="form-label">Correct Answer (Complex)</label>
                                    <textarea class="form-control" id="multiple_answer" name="multiple_answer" rows="2"><?php echo htmlspecialchars($question['multiple_answer'] ?? ''); ?></textarea>
                                    <div class="form-text">Enter the correct answer for the complex/multiple question.</div>
                                </div>
                            </div>
                        </div>

                        <!-- Other Version Tab (Added) -->
                        <div class="tab-pane fade" id="other" role="tabpanel" aria-labelledby="other-tab">
                            <div class="form-section">
                                <div class="section-title">Alternative Version</div>
                                
                                
                                <div class="mb-3">
                                    <label for="simple_question_other" class="form-label">Alternative Question</label>
                                    <textarea class="form-control" id="simple_question_other" name="simple_question_other" rows="4"><?php echo htmlspecialchars($question['simple_question_other'] ?? ''); ?></textarea>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="simple_choice_1_other" class="form-label">Alternative Option 1</label>
                                        <textarea class="form-control" id="simple_choice_1_other" name="simple_choice_1_other" rows="2"><?php echo htmlspecialchars($question['simple_choice_1_other'] ?? ''); ?></textarea>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="simple_choice_2_other" class="form-label">Alternative Option 2</label>
                                        <textarea class="form-control" id="simple_choice_2_other" name="simple_choice_2_other" rows="2"><?php echo htmlspecialchars($question['simple_choice_2_other'] ?? ''); ?></textarea>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="simple_choice_3_other" class="form-label">Alternative Option 3</label>
                                        <textarea class="form-control" id="simple_choice_3_other" name="simple_choice_3_other" rows="2"><?php echo htmlspecialchars($question['simple_choice_3_other'] ?? ''); ?></textarea>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="simple_choice_4_other" class="form-label">Alternative Option 4</label>
                                        <textarea class="form-control" id="simple_choice_4_other" name="simple_choice_4_other" rows="2"><?php echo htmlspecialchars($question['simple_choice_4_other'] ?? ''); ?></textarea>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="simple_answer_other" class="form-label">Alternative Correct Answer</label>
                                    <textarea class="form-control" id="simple_answer_other" name="simple_answer_other" rows="2"><?php echo htmlspecialchars($question['simple_answer_other'] ?? ''); ?></textarea>
                                    <div class="form-text">Enter the correct answer text for the alternative version.</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3 mt-4">
                        <label for="des" class="form-label">Description/Explanation</label>
                        <textarea class="form-control" id="des" name="des" rows="3"><?php echo htmlspecialchars($question['des'] ?? ''); ?></textarea>
                    </div>

                    <div class="d-flex justify-content-between mt-4">
                        <a href="index.php" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save me-2"></i>Save Changes
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script>
       $(document).ready(function() {
    // Store the initial MCQ type
    const initialMcqType = '<?php echo $question['mcq_type']; ?>';
    const initialOtherFlag = '<?php echo $question['other_flag']; ?>';
    
    // Set active tab based on MCQ type
    if (initialMcqType == '1') {
        $('#simple-tab').tab('show');
    } else if (initialMcqType == '2') {
        $('#multiple-tab').tab('show');
    }
    else if (initialMcqType == '3') {
        $('#other-tab').tab('show');
    }
    
    
    

    
    // Function to show notifications
    function showNotification(message) {
        // Create notification element
        const notification = $(`
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <i class="fas fa-info-circle me-2"></i>${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        `);
        
        // Insert at the top of the form
        $('form').prepend(notification);
        
        // Auto dismiss after 5 seconds
        setTimeout(function() {
            notification.alert('close');
        }, 5000);
    }
    
    // Add form validation
    $('form').on('submit', function(e) {
        // Basic validation for simple MCQ
        if ($('#simple-tab').hasClass('active')) {
            if (!$('#simple_question').val().trim()) {
                e.preventDefault();
                showValidationError('#simple_question', 'Question is required');
                return false;
            }
            
            if (!$('#simple_answer').val().trim()) {
                e.preventDefault();
                showValidationError('#simple_answer', 'Correct answer is required');
                return false;
            }
        }
        
        // Basic validation for complex MCQ
        if ($('#multiple-tab').hasClass('active')) {
            if (!$('#multiple_question').val().trim()) {
                e.preventDefault();
                showValidationError('#multiple_question', 'Main question is required');
                return false;
            }
            
            if (!$('#multiple_answer').val().trim()) {
                e.preventDefault();
                showValidationError('#multiple_answer', 'Correct answer is required');
                return false;
            }
        }
        
   
        
        return true;
    });
    
    // Function to show validation errors
    function showValidationError(fieldId, message) {
        // Add error class to the field
        $(fieldId).addClass('is-invalid');
        
        // Remove any existing error message
        $(fieldId).siblings('.invalid-feedback').remove();
        
        // Add error message
        $(fieldId).after(`<div class="invalid-feedback">${message}</div>`);
        
        // Focus on the field
        $(fieldId).focus();
        
        // Remove error class when the field is edited
        $(fieldId).one('input', function() {
            $(this).removeClass('is-invalid');
            $(this).siblings('.invalid-feedback').remove();
        });
    }
    
    // When tab is shown, focus on the first field in that tab
    $('button[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
        const targetId = $(e.target).attr('data-bs-target');
        $(targetId).find('textarea, input').not(':hidden').first().focus();
    });
    
    // Add confirmation before leaving page with unsaved changes
    let formChanged = false;
    
    $('form :input').on('change', function() {
        formChanged = true;
    });
    
    $(window).on('beforeunload', function() {
        if (formChanged) {
            return "You have unsaved changes. Are you sure you want to leave this page?";
        }
    });
    
    // Reset the form changed flag when form is submitted
    $('form').on('submit', function() {
        formChanged = false;
    });
});
</script>
</body>
</html>