<?php
// Set character encoding to properly display Bangla characters
header('Content-Type: text/html; charset=utf-8');

// Include database connection
include 'connection.php';

// Check if ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo '<div class="alert alert-danger">Invalid question ID</div>';
    exit;
}

$id = intval($_GET['id']);

// Sanitize the ID to prevent SQL injection
$id = $conn->real_escape_string($id);

// Ensure connection is using UTF-8
$conn->set_charset("utf8mb4");

// Query to fetch question details
$sql = "SELECT 
    qm.*,
    c.name as class_name,
    s.name as subject_name,
    ch.chapter_name
FROM 
    qb_chapter_mcq qm
LEFT JOIN 
    qb_classes c ON qm.class_id = c.id
LEFT JOIN 
    qb_subjects s ON qm.subject_id = s.id
LEFT JOIN 
    qb_chapters ch ON qm.chapter_id = ch.id
WHERE 
    qm.id = '$id'";

$result = $conn->query($sql);

// Check for query errors
if ($result === false) {
    echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars($conn->error) . '</div>';
    exit;
}

if ($result->num_rows === 0) {
    echo '<div class="alert alert-warning">Question not found</div>';
    exit;
}

$question = $result->fetch_assoc();

// Function to determine which choice contains the correct answer
function getCorrectChoiceNumber($question) {
    $answer = $question['simple_answer'] ?? '';
    
    if (strcasecmp($answer, $question['simple_choice_1'] ?? '') === 0) return 1;
    if (strcasecmp($answer, $question['simple_choice_2'] ?? '') === 0) return 2;
    if (strcasecmp($answer, $question['simple_choice_3'] ?? '') === 0) return 3;
    if (strcasecmp($answer, $question['simple_choice_4'] ?? '') === 0) return 4;
    
    return 0; // If no match is found
}

$correctChoice = getCorrectChoiceNumber($question);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Add Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4f46e5;
            --primary-light: #eef2ff;
            --correct-color: #10b981;
            --hover-color: #f8fafc;
            --border-color: #e2e8f0;
            --text-color: #334155;
            --light-text: #64748b;
            --heading-color: #1e293b;
            --card-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: #f8fafc;
            font-size: 14px;
            color: var(--text-color);
            line-height: 1.6;
        }
        
        .container-fluid {
            max-width: 1400px;
            padding: 0 20px;
        }
        
        .main-container {
            margin: 30px auto;
        }
        
        .card {
            border-radius: 12px;
            border: none;
            box-shadow: var(--card-shadow);
            margin-bottom: 24px;
            overflow: hidden;
            background: white;
        }
        
        .card-header {
            background: var(--primary-color);
            color: white;
            padding: 16px 20px;
            font-weight: 500;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: none;
        }
        
        .card-header h5 {
            margin: 0;
            font-size: 16px;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .card-header-icon {
            background: rgba(255, 255, 255, 0.2);
            width: 32px;
            height: 32px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 12px;
        }
        
        .card-header .meta {
            font-size: 13px;
            opacity: 0.9;
        }
        
        .card-body {
            padding: 24px;
        }
        
        .question-id {
            display: inline-block;
            background: rgba(255, 255, 255, 0.2);
            padding: 3px 10px;
            border-radius: 20px;
            font-size: 12px;
            margin-left: 10px;
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 16px;
        }
        
        .info-item {
            background: var(--primary-light);
            border-radius: 8px;
            padding: 12px 16px;
        }
        
        .info-label {
            font-size: 12px;
            color: var(--light-text);
            margin-bottom: 4px;
        }
        
        .info-value {
            font-weight: 500;
            color: var(--heading-color);
            font-size: 14px;
        }
        
        .label {
            font-weight: 500;
            color: var(--heading-color);
            margin-bottom: 10px;
            font-size: 15px;
            display: flex;
            align-items: center;
        }
        
        .label i {
            margin-right: 8px;
            color: var(--primary-color);
        }
        
        .content-text {
            border: 1px solid var(--border-color);
            padding: 14px 16px;
            border-radius: 8px;
            background: white;
            margin-bottom: 16px;
            min-height: 40px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }
        
        .option-container {
            display: flex;
            margin-bottom: 12px;
            align-items: center;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            overflow: hidden;
            transition: all 0.2s ease;
        }
        
        .option-container:hover {
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        .option-label {
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f1f5f9;
            color: var(--text-color);
            font-weight: 500;
            font-size: 14px;
            flex-shrink: 0;
            border-right: 1px solid var(--border-color);
        }
        
        .option-correct {
            border: 2px solid var(--correct-color);
            background: #ecfdf5;
        }
        
        .option-correct .option-label {
            background: var(--correct-color);
            color: white;
        }
        
        .option-text {
            flex-grow: 1;
            padding: 10px 16px;
        }
        
        .check-icon {
            margin-right: 16px;
            color: var(--correct-color);
            font-size: 18px;
        }
        
        .answer-container {
            background: #ecfdf5;
            border-radius: 8px;
            padding: 16px;
            margin-top: 16px;
            border: 1px solid #d1fae5;
        }
        
        .answer-label {
            color: var(--correct-color);
            font-weight: 500;
            font-size: 14px;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
        }
        
        .answer-label i {
            margin-right: 8px;
        }
        
        .divider {
            height: 1px;
            background: var(--border-color);
            margin: 24px 0;
        }
        
        .section-title {
            font-weight: 600;
            color: var(--heading-color);
            margin-bottom: 16px;
            font-size: 16px;
            border-bottom: 2px solid var(--primary-light);
            padding-bottom: 8px;
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 8px;
            color: var(--primary-color);
        }
        
        .badge-custom {
            background: var(--primary-color);
            color: white;
            font-weight: 400;
            font-size: 11px;
            padding: 4px 10px;
            border-radius: 12px;
        }
        
        @media (max-width: 768px) {
            .main-container {
                margin: 15px auto;
            }
            
            .info-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid main-container">
        <!-- Question Information Card -->
        <div class="card">
            <div class="card-header">
                <h5>
                    <div class="card-header-icon">
                        <i class="fas fa-info"></i>
                    </div>
                    Question Information
                    <span class="question-id">#<?php echo $question['id']; ?></span>
                </h5>
                <div class="meta">
                    <span class="badge-custom"><?php echo $question['class_name']; ?></span>
                    <span class="badge-custom"><?php echo $question['subject_name']; ?></span>
                    <span class="badge-custom"><?php echo $question['chapter_name']; ?></span>
                </div>
            </div>
            <div class="card-body">
                <div class="info-grid">
                    <div class="info-item">
                        <div class="info-label">Question ID</div>
                        <div class="info-value"><?php echo $question['id']; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">System ID</div>
                        <div class="info-value"><?php echo $question['q_id'] ?? 'N/A'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Class</div>
                        <div class="info-value"><?php echo $question['class_name'] ?? 'N/A'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Subject</div>
                        <div class="info-value"><?php echo $question['subject_name'] ?? 'N/A'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Chapter</div>
                        <div class="info-value"><?php echo $question['chapter_name'] ?? 'N/A'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Sub-Chapter</div>
                        <div class="info-value"><?php echo $question['subchapter_id'] ?? 'N/A'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Status</div>
                        <div class="info-value"><?php echo $question['status'] ?? 'N/A'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Date Added</div>
                        <div class="info-value"><?php echo date('M d, Y', strtotime($question['created_at'])); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Reference</div>
                        <div class="info-value"><?php echo $question['ref'] ?? 'N/A'; ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Year</div>
                        <div class="info-value"><?php echo $question['year'] ?? 'N/A'; ?></div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Question and Multiple Question Section -->
        <div class="row">
            <!-- Question Section -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>
                            <div class="card-header-icon">
                                <i class="fas fa-question"></i>
                            </div>
                            Question
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="content-text"><?php echo nl2br($question['mcq_stamp'] ?? 'কোনো উদ্দীপক নেই '); ?></div>
                        <div class="content-text"><?php echo nl2br($question['simple_question'] ?? 'প্রশ্ন নেই'); ?></div>
                        
                        <div class="section-title">
                            <i class="fas fa-list-ol"></i> Answer Choices
                        </div>
                        
                        <?php for ($i = 1; $i <= 4; $i++): ?>
                            <div class="option-container <?php echo ($correctChoice == $i) ? 'option-correct' : ''; ?>">
                                <div class="option-label"><?php echo $i; ?></div>
                                <div class="option-text"><?php echo $question['simple_choice_' . $i] ?? 'প্রশ্ন নেই'; ?></div>
                                <?php if ($correctChoice == $i): ?>
                                    <div class="check-icon">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endfor; ?>
                        
                        <div class="answer-container">
                            <div class="answer-label">
                                <i class="fas fa-check-double"></i> Correct Answer
                            </div>
                            <div><?php echo $question['simple_answer'] ?? 'প্রশ্ন নেই'; ?></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Multiple Question Section -->
            <div class="col-md-6">
                <?php if (!empty($question['multiple_question']) && $question['multiple_question'] != 'প্রশ্ন নেই'): ?>
                <div class="card">
                    <div class="card-header">
                        <h5>
                            <div class="card-header-icon">
                                <i class="fas fa-clipboard-list"></i>
                            </div>
                            Multiple Question Information
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="label">
                            <i class="fas fa-align-left"></i> Main Question
                        </div>
                        <div class="content-text"><?php echo nl2br($question['multiple_question']); ?></div>
                        
                        <?php if (!empty($question['multiple_q_one']) && $question['multiple_q_one'] != 'প্রশ্ন নেই'): ?>
                        <div class="mt-3">
                            <div class="label">
                                <i class="fas fa-check-circle"></i> Multiple Question
                            </div>
                            <div class="content-text"><?php echo $question['multiple_q_one']; ?></div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($question['multiple_q_two']) && $question['multiple_q_two'] != 'প্রশ্ন নেই'): ?>
                        <div class="mt-3">
                            <div class="label">
                                
                            </div>
                            <div class="content-text"><?php echo $question['multiple_q_two']; ?></div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($question['multiple_q_three']) && $question['multiple_q_three'] != 'প্রশ্ন নেই'): ?>
                        <div class="mt-3">
                            <div class="label">
                                
                            </div>
                            <div class="content-text"><?php echo $question['multiple_q_three']; ?></div>
                        </div>
                        <?php endif; ?>
                        
                        <div class="divider"></div>
                        
                        <div class="section-title">
                            <i class="fas fa-list-ol"></i> Answer Choices
                        </div>
                        
                        <?php 
                        $multipleChoices = [
                            '1' => $question['multiple_choice_i'] ?? 'প্রশ্ন নেই',
                            '2' => $question['multiple_choice_ii'] ?? 'প্রশ্ন নেই',
                            '3' => $question['multiple_choice_iii'] ?? 'প্রশ্ন নেই',
                            '4' => $question['multiple_choice_iv'] ?? 'প্রশ্ন নেই'
                        ];
                        
                        $multipleAnswer = $question['multiple_answer'] ?? '';
                        
                        foreach ($multipleChoices as $key => $choice):
                            if (empty($choice) || $choice == 'N/A') continue;
                            $isCorrect = (stripos($multipleAnswer, $choice) !== false);
                        ?>
                        <div class="option-container <?php echo $isCorrect ? 'option-correct' : ''; ?>">
                            <div class="option-label"><?php echo $key; ?></div>
                            <div class="option-text"><?php echo $choice; ?></div>
                            <?php if ($isCorrect): ?>
                                <div class="check-icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                        
                        <?php if (!empty($question['multiple_answer']) && $question['multiple_answer'] != 'N/A'): ?>
                        <div class="answer-container">
                            <div class="answer-label">
                                <i class="fas fa-check-double"></i> Correct Answer
                            </div>
                            <div><?php echo $question['multiple_answer']; ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php else: ?>
                <div class="card">
                    <div class="card-header">
                        <h5>
                            <div class="card-header-icon">
                                <i class="fas fa-clipboard-list"></i>
                            </div>
                            Multiple Question Information
                        </h5>
                    </div>
                    <div class="card-body text-center py-5">
                        <i class="fas fa-info-circle mb-3" style="font-size: 48px; color: #cbd5e0;"></i>
                        <p>No multiple question information available for this question.</p>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Other Language Version -->
        <?php 
        $hasOtherLanguage = !empty($question['simple_question_other']) && $question['simple_question_other'] != 'N/A';
        $hasChoices = false;
        for ($i = 1; $i <= 4; $i++) {
            if (!empty($question['simple_choice_' . $i . '_other']) && $question['simple_choice_' . $i . '_other'] != 'N/A') {
                $hasChoices = true;
                break;
            }
        }
        if ($hasOtherLanguage || $hasChoices):
        ?>
        <div class="card">
            <div class="card-header">
                <h5>
                    <div class="card-header-icon">
                        <i class="fas fa-language"></i>
                    </div>
                    Other Questions
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <div class="label">
                            <i class="fas fa-question"></i> Question
                        </div>
                        <div class="content-text"><?php echo nl2br($question['simple_question_other'] ?? 'N/A'); ?></div>
                        
                        <div class="section-title mt-4">
                            <i class="fas fa-list-ol"></i> Answer Choices
                        </div>
                        
                        <?php 
                        $otherAnswer = $question['simple_answer_other'] ?? '';
                        for ($i = 1; $i <= 4; $i++): 
                            if (empty($question['simple_choice_' . $i . '_other']) || $question['simple_choice_' . $i . '_other'] == 'N/A') continue;
                            $isCorrect = (strcasecmp($otherAnswer, $question['simple_choice_' . $i . '_other']) === 0);
                        ?>
                        <div class="option-container <?php echo $isCorrect ? 'option-correct' : ''; ?>">
                            <div class="option-label"><?php echo $i; ?></div>
                            <div class="option-text"><?php echo $question['simple_choice_' . $i . '_other']; ?></div>
                            <?php if ($isCorrect): ?>
                                <div class="check-icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php endfor; ?>
                        
                        <?php if (!empty($question['simple_answer_other']) && $question['simple_answer_other'] != 'N/A'): ?>
                        <div class="answer-container">
                            <div class="answer-label">
                                <i class="fas fa-check-double"></i> Correct Answer
                            </div>
                            <div><?php echo $question['simple_answer_other']; ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Bootstrap JS with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>