<?php
include "connection.php";

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the subject_id from the request
if (!isset($_GET['subject_id']) || !is_numeric($_GET['subject_id'])) {
    die("Invalid subject ID");
}
$subject_id = $_GET['subject_id'];

// SQL query to get the chapters for the given subject_id
$sql = "
    SELECT id, chapter_name
    FROM qb_chapters
    WHERE subject_id = ?
";

// Prepare and execute the query
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    die('Error in query preparation: ' . $conn->error);
}

$stmt->bind_param("i", $subject_id);

// Debugging: check if the query runs without error
if (!$stmt->execute()) {
    die('Error executing query: ' . $stmt->error);
}

$result = $stmt->get_result();

// Prepare the response
$chapters = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $chapters[] = $row;
    }
} else {
    // No chapters found
    $chapters = ['message' => 'No chapters found for this subject'];
}

// Return the chapters as a JSON response
echo json_encode($chapters);
?>
