<?php
include "connection.php";

// Get the class_id from the request
$class_id = $_GET['class_id'];

// SQL query to get the subjects for the given class_id
$sql = "
    SELECT s.id, s.name
    FROM qb_subjects s
    JOIN qb_class_subject_mapping csm ON s.id = csm.subject_id
    WHERE csm.class_id = ? AND s.is_active = 1
";

// Prepare and execute the query
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    die('Error in query preparation: ' . $conn->error);
}

$stmt->bind_param("i", $class_id);
$stmt->execute();
$result = $stmt->get_result();

// Prepare the response
$subjects = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $subjects[] = $row;
    }
}

// Return the subjects as a JSON response
echo json_encode($subjects);
?>
