<?php
// Include database connection
include 'connection.php';

// Set page title
$pageTitle = "Smart Question Management System";

// Initialize pagination variables
$recordsPerPage = 10;
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $recordsPerPage;

// Query to fetch questions with pagination
$sql = "SELECT 
    qm.id,
    qm.simple_question,
    qm.mcq_type,
    c.name as class_name,
    s.name as subject_name,
    ch.chapter_name,
    qm.created_at
FROM 
    qb_chapter_mcq qm
LEFT JOIN 
    qb_classes c ON qm.class_id = c.id
LEFT JOIN 
    qb_subjects s ON qm.subject_id = s.id
LEFT JOIN 
    qb_chapters ch ON qm.chapter_id = ch.id
ORDER BY 
    qm.id DESC
LIMIT $offset, $recordsPerPage";

// Count total records for pagination
$countSql = "SELECT COUNT(*) as total FROM qb_chapter_mcq";
$countResult = $conn->query($countSql);
$totalRecords = $countResult->fetch_assoc()['total'];
$totalPages = ceil($totalRecords / $recordsPerPage);

$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --accent-color: #4cc9f0;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4caf50;
            --danger-color: #f44336;
            --warning-color: #ff9800;
            --info-color: #2196f3;
        }
        
        body {
            background-color: #f0f2f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--dark-color);
        }
        
        .container {
            max-width: 1200px;
            padding-top: 2rem;
            padding-bottom: 2rem;
        }
        
        /* Improved header container with glassmorphism effect */
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            background: linear-gradient(135deg, var(--primary-color), var(--accent-color));
            padding: 1.8rem 2.5rem;
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
            position: relative;
            overflow: hidden;
        }
        
        .header-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), rgba(255, 255, 255, 0.05));
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-radius: 12px;
            z-index: 0;
        }
        
        .header-container h1 {
            color: white;
            margin: 0;
            font-weight: 700;
            font-size: 2rem;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
            position: relative;
            z-index: 1;
        }
        
        .header-container .btn-primary {
            background-color: white;
            color: var(--primary-color);
            border: none;
            font-weight: 600;
            padding: 0.7rem 1.4rem;
            border-radius: 30px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
            transition: all 0.3s ease;
            position: relative;
            z-index: 1;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .header-container .btn-primary:hover {
            background-color: var(--light-color);
            transform: translateY(-3px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
        }
        
        /* Enhanced card */
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 5px 18px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            margin-bottom: 2rem;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
        }
        
        .card-header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            padding: 1.2rem 1.5rem;
            border-bottom: none;
        }
        
        .card-header h5 {
            color: white;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 1.3rem;
            margin: 0;
        }
        
        .card-header h5:before {
            content: '\f059';
            font-family: 'Font Awesome 5 Free';
            font-weight: 900;
        }
        
        .card-body {
            padding: 1.8rem;
        }
        
        /* Table styling */
        .table {
            margin-bottom: 0;
            border-collapse: separate;
            border-spacing: 0;
        }
        
        .table thead th {
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            padding: 1rem;
            border-top: none;
            border-bottom: 2px solid var(--primary-color);
            font-size: 0.85rem;
        }
        
        .table tbody tr {
            transition: background-color 0.3s ease;
        }
        
        .table tbody tr:hover {
            background-color: rgba(67, 97, 238, 0.05);
        }
        
        .table td {
            padding: 1rem;
            vertical-align: middle;
            border-top: 1px solid #e9ecef;
        }
        
        .question-text {
            max-width: 300px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            font-weight: 500;
        }
        
        /* Button groups */
        .btn-group-sm .btn {
            border-radius: 4px;
            padding: 0.4rem 0.8rem;
            font-size: 0.85rem;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        .btn-info {
            background-color: var(--info-color);
            border-color: var(--info-color);
            color: white;
        }
        
        .btn-warning {
            background-color: var(--warning-color);
            border-color: var(--warning-color);
            color: white;
        }
        
        .btn-danger {
            background-color: var(--danger-color);
            border-color: var(--danger-color);
        }
        
        .btn-info:hover, .btn-warning:hover, .btn-danger:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }
        
        /* Custom pagination */
        .pagination-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
        }
        
        .pagination {
            margin: 0;
        }
        
        .pagination .page-item .page-link {
            border: none;
            color: var(--primary-color);
            border-radius: 4px;
            margin: 0 3px;
            transition: all 0.3s ease;
            font-weight: 500;
            padding: 0.5rem 0.9rem;
        }
        
        .pagination .page-item.active .page-link {
            background-color: var(--primary-color);
            color: white;
            box-shadow: 0 4px 8px rgba(67, 97, 238, 0.25);
        }
        
        .pagination .page-item .page-link:hover {
            background-color: rgba(67, 97, 238, 0.1);
            transform: translateY(-2px);
        }
        
        .page-info {
            font-size: 0.9rem;
            color: #6c757d;
        }
        
        /* Alerts styling */
        .alert {
            border-radius: 8px;
            border: none;
            padding: 1rem 1.5rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .alert-success {
            background-color: rgba(76, 175, 80, 0.15);
            color: #2e7d32;
        }
        
        .alert-danger {
            background-color: rgba(244, 67, 54, 0.15);
            color: #c62828;
        }
        
        .alert i {
            margin-right: 10px;
            font-size: 1.2rem;
        }
        
        /* Modal styling */
        .modal-content {
            border: none;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.2);
        }
        
        .modal-header {
            background: linear-gradient(135deg, var(--info-color), #03a9f4);
            border-bottom: none;
            padding: 1.2rem 1.5rem;
        }
        
        .modal-title {
            color: white;
            font-weight: 600;
        }
        
        .modal-body {
            padding: 1.8rem;
        }
        
        .modal-footer {
            border-top: 1px solid #e9ecef;
            padding: 1rem 1.5rem;
        }
        
        .btn-secondary {
            background-color: #6c757d;
            border-color: #6c757d;
            color: white;
            transition: all 0.3s ease;
        }
        
        .btn-secondary:hover {
            background-color: #5a6268;
            border-color: #545b62;
            transform: translateY(-2px);
        }
        
        /* Empty state */
        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
        }
        
        .empty-state i {
            font-size: 3rem;
            color: #d1d5db;
            margin-bottom: 1rem;
        }
        
        .empty-state p {
            color: #6c757d;
            font-size: 1.1rem;
            max-width: 500px;
            margin: 0 auto;
        }
        
        /* Mobile responsiveness */
        @media (max-width: 992px) {
            .header-container {
                padding: 1.5rem 2rem;
            }
            
            .header-container h1 {
                font-size: 1.7rem;
            }
        }
        
        @media (max-width: 768px) {
            .header-container {
                flex-direction: column;
                text-align: center;
                gap: 1rem;
                padding: 1.5rem;
            }
            
            .header-container h1 {
                margin-bottom: 1rem;
            }
            
            .header-container .btn-primary {
                width: 100%;
                justify-content: center;
            }
            
            .table-responsive {
                border-radius: 12px;
                overflow: hidden;
            }
            
            .card-body {
                padding: 1.2rem;
            }
            
            .pagination-container {
                flex-direction: column;
                gap: 1rem;
            }
            
            .page-info {
                order: -1;
            }
        }
        
        @media (max-width: 576px) {
            .container {
                padding-top: 1rem;
                padding-bottom: 1rem;
            }
            
            .header-container h1 {
                font-size: 1.5rem;
            }
            
            .btn-group-sm .btn {
                padding: 0.3rem 0.6rem;
                font-size: 0.75rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header-container">
            <h1><i class="fas fa-question-circle me-2"></i>Smart Question Management System</h1>
            <a href="Add_Question.php" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Question
            </a>
        </div>

        <?php
        // Display success or error messages if they exist
        if (isset($_GET['success'])) {
            echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle"></i>' . htmlspecialchars($_GET['success']) . '
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                  </div>';
        }
        
        if (isset($_GET['error'])) {
            echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle"></i>' . htmlspecialchars($_GET['error']) . '
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                  </div>';
        }
        ?>

        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Question List</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Question</th>
                                <th>Type</th>
                                <th>Class</th>
                                <th>Subject</th>
                                <th>Chapter</th>
                                <th>Date Added</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if ($result && $result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>";
                                    echo "<td>" . $row['id'] . "</td>";
                                    echo "<td class='question-text'>" . htmlspecialchars($row['simple_question']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['mcq_type']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['class_name'] ?? 'N/A') . "</td>";
                                    echo "<td>" . htmlspecialchars($row['subject_name'] ?? 'N/A') . "</td>";
                                    echo "<td>" . htmlspecialchars($row['chapter_name'] ?? 'N/A') . "</td>";
                                    echo "<td>" . date('Y-m-d', strtotime($row['created_at'])) . "</td>";
                                    echo "<td>
                                            <div class='btn-group btn-group-sm'>
                                                <button type='button' class='btn btn-info view-btn' data-id='" . $row['id'] . "'>
                                                    <i class='fas fa-eye me-1'></i>View
                                                </button>
                                                <a href='edit.php?id=" . $row['id'] . "' class='btn btn-warning'>
                                                    <i class='fas fa-edit me-1'></i>Edit
                                                </a>
                                                <a href='delete.php?id=" . $row['id'] . "' class='btn btn-danger' onclick='return confirm(\"Are you sure you want to delete this question?\");'>
                                                    <i class='fas fa-trash-alt me-1'></i>Delete
                                                </a>
                                            </div>
                                          </td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo "<tr>
                                        <td colspan='8'>
                                            <div class='empty-state'>
                                                <i class='fas fa-question-circle'></i>
                                                <p>No questions found. Add your first question to get started!</p>
                                            </div>
                                        </td>
                                      </tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Server-side pagination -->
                <div class="pagination-container">
                    <div class="page-info">
                        Showing <?php echo $offset + 1; ?> to <?php echo min($offset + $recordsPerPage, $totalRecords); ?> of <?php echo $totalRecords; ?> questions
                    </div>
                    
                    <nav aria-label="Question list navigation">
                        <ul class="pagination">
                            <?php if ($page > 1): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=1" aria-label="First">
                                        <i class="fas fa-angle-double-left"></i>
                                    </a>
                                </li>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $page - 1; ?>" aria-label="Previous">
                                        <i class="fas fa-angle-left"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                            
                            <?php
                            // Calculate range of page numbers to display
                            $startPage = max(1, $page - 2);
                            $endPage = min($totalPages, $page + 2);
                            
                            // Always show first page
                            if ($startPage > 1) {
                                echo '<li class="page-item"><a class="page-link" href="?page=1">1</a></li>';
                                if ($startPage > 2) {
                                    echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                                }
                            }
                            
                            // Display page numbers
                            for ($i = $startPage; $i <= $endPage; $i++) {
                                $activeClass = ($i == $page) ? 'active' : '';
                                echo '<li class="page-item ' . $activeClass . '"><a class="page-link" href="?page=' . $i . '">' . $i . '</a></li>';
                            }
                            
                            // Always show last page
                            if ($endPage < $totalPages) {
                                if ($endPage < $totalPages - 1) {
                                    echo '<li class="page-item disabled"><span class="page-link">...</span></li>';
                                }
                                echo '<li class="page-item"><a class="page-link" href="?page=' . $totalPages . '">' . $totalPages . '</a></li>';
                            }
                            ?>
                            
                            <?php if ($page < $totalPages): ?>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $page + 1; ?>" aria-label="Next">
                                        <i class="fas fa-angle-right"></i>
                                    </a>
                                </li>
                                <li class="page-item">
                                    <a class="page-link" href="?page=<?php echo $totalPages; ?>" aria-label="Last">
                                        <i class="fas fa-angle-double-right"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <!-- View Question Modal -->
    <div class="modal fade" id="viewQuestionModal" tabindex="-1" aria-labelledby="viewQuestionModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="viewQuestionModalLabel">Question Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="questionDetails">
                        <div class="text-center">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <p class="mt-2">Loading question details...</p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // View question in modal
            $(document).on('click', '.view-btn', function() {
                let questionId = $(this).data('id');
                $('#questionDetails').html('<div class="text-center"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div><p class="mt-2">Loading question details...</p></div>');
                $('#viewQuestionModal').modal('show');
                
                // Fetch question details via AJAX
                $.ajax({
                    url: 'fetch_question.php',
                    type: 'GET',
                    data: { id: questionId },
                    success: function(response) {
                        $('#questionDetails').html(response);
                    },
                    error: function() {
                        $('#questionDetails').html('<div class="alert alert-danger"><i class="fas fa-exclamation-circle me-2"></i>Error loading question details. Please try again.</div>');
                    }
                });
            });
        });
    </script>
</body>
</html>