<?php
// Include database connection
include '../connection.php';

// Set page title
$pageTitle = "Smart Question Management System";

// Query to fetch all questions from the database
$sql = "SELECT 
    qm.id,
    qm.simple_question,
    qm.mcq_type,
    c.name as class_name,
    s.name as subject_name,
    ch.chapter_name,
    qm.created_at
FROM 
    qb_chapter_mcq qm
LEFT JOIN 
    qb_classes c ON qm.class_id = c.id
LEFT JOIN 
    qb_subjects s ON qm.subject_id = s.id
LEFT JOIN 
    qb_chapters ch ON qm.chapter_id = ch.id
ORDER BY 
    qm.id DESC limit 10";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <style>
        .question-text {
            max-width: 300px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="header-container">
            <h1><?php echo $pageTitle; ?></h1>
            <a href="step1.php" class="btn btn-primary">Add New Question</a>
        </div>

        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="card-title mb-0">Question List</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="questionTable" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Question</th>
                                <th>Type</th>
                                <th>Class</th>
                                <th>Subject</th>
                                <th>Chapter</th>
                                <th>Date Added</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if ($result && $result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>";
                                    echo "<td>" . $row['id'] . "</td>";
                                    echo "<td class='question-text'>" . htmlspecialchars($row['simple_question']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['mcq_type']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['class_name'] ?? 'N/A') . "</td>";
                                    echo "<td>" . htmlspecialchars($row['subject_name'] ?? 'N/A') . "</td>";
                                    echo "<td>" . htmlspecialchars($row['chapter_name'] ?? 'N/A') . "</td>";
                                    echo "<td>" . date('Y-m-d', strtotime($row['created_at'])) . "</td>";
                                    echo "<td>
                                            <div class='btn-group btn-group-sm'>
                                                <a href='view.php?id=" . $row['id'] . "' class='btn btn-info'>View</a>
                                                <a href='edit.php?id=" . $row['id'] . "' class='btn btn-warning'>Edit</a>
                                                <a href='delete.php?id=" . $row['id'] . "' class='btn btn-danger' onclick='return confirm(\"Are you sure you want to delete this question?\");'>Delete</a>
                                            </div>
                                          </td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo "<tr><td colspan='8' class='text-center'>No questions found</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#questionTable').DataTable({
                "pageLength": 10,
                "order": [[0, "desc"]],
                "language": {
                    "search": "Search questions:",
                    "lengthMenu": "Show _MENU_ questions per page",
                    "info": "Showing _START_ to _END_ of _TOTAL_ questions"
                }
            });
        });
    </script>
</body>
</html>