<?php $__env->startSection('title', 'Student Edit'); ?>

<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Edit Student</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item ">
                    <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                </li>
                <li class="breadcrumb-item ">
                    <a href="<?php echo e(route('students.index')); ?>">Student List</a>
                </li>
                <li class="breadcrumb-item active">Edit Student</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Edit Student</h4>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('students.update', ['student' => $student->id])); ?>" enctype="multipart/form-data" method="post">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="name">Student Name*</label>
                                    <input type="text" name="student_name" value="<?php echo e($student->student_name); ?>" class="form-control form-control-sm <?php $__errorArgs = ['student_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Student Name" id="name" />
                                    <?php $__errorArgs = ['student_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="phone">Student Contact*</label>
                                    <input type="tel" name="student_contact" value="<?php echo e($student->student_contact); ?>" class="form-control form-control-sm <?php $__errorArgs = ['student_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Student Contact" id="phone" />
                                    <?php $__errorArgs = ['student_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="guardian_name">Guardian Name</label>
                                    <input type="text" name="guardian_name" value="<?php echo e($student->guardian_name); ?>" class="form-control form-control-sm <?php $__errorArgs = ['guardian_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Guardian Name" id="guardian_name" />
                                    <?php $__errorArgs = ['guardian_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="father_contact">Guardian Contact</label>
                                    <input type="tel" name="guardian_contact" value="<?php echo e($student->guardian_contact); ?>" class="form-control form-control-sm <?php $__errorArgs = ['guardian_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Student Contact" id="father_contact" />
                                    <?php $__errorArgs = ['guardian_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="batch">Batch*</label>
                                    <select name="batch" id="batch" class="form-control form-control-sm <?php $__errorArgs = ['batch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                        <option value="" hidden>Select Batch</option>
                                        <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php if($student->batch_id == $batch->id): ?> selected <?php endif; ?>
                                                value="<?php echo e($batch->id); ?>"
                                                data-class="<?php echo e($batch->batch_class); ?>"
                                            >
                                                <?php echo e($batch->batch_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['batch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="class">Student Class*</label>
                                    <input type="text" readonly name="student_class" value="<?php echo e($student->student_class); ?>" class="form-control form-control-sm <?php $__errorArgs = ['student_class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Student Class" id="class" />
                                    <?php $__errorArgs = ['student_class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="clg">College Name</label>
                                    <input type="text" name="clg_name" value="<?php echo e($student->clg_name); ?>" class="form-control form-control-sm <?php $__errorArgs = ['clg_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="College Name" id="clg" />
                                    <?php $__errorArgs = ['clg_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="admission_date">Admission Date*</label>
                                    <input type="date" name="admission_date" value="<?php echo e($student->admission_date ? date('Y-m-d', strtotime($student->admission_date)) : date('Y-m-d')); ?>" class="form-control form-control-sm <?php $__errorArgs = ['admission_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="admission_date" required />
                                    <?php $__errorArgs = ['admission_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>


                            
                            <input type="file" style="display: none;" name="user_profile" id="user_profile">
                            
                            <input type="hidden" name="camera_phone_input" id="camera_phone_input">

                            <div class="col-md-6 col-sm-12">
                                <label for="">User Profile</label>
                                <div class="form-group border rounded m-auto text-center p-1">
                                    <div class="mb-1" style="width:260px;height:260px;border:1px solid black;display:block;padding:4px;margin:auto;overflow:hidden;">
                                        <?php
                                        $canRemove = false;
                                        ?>

                                        <?php if($student->user_profile): ?>
                                            <?php if(file_exists(public_path("storage/students/".$student->user_profile))): ?>
                                                <?php $canRemove = true; ?>
                                                <img id="user_profile_preview" style="width:250px;height:250px;" src="<?php echo e(asset("storage/students/".$student->user_profile)); ?>" alt="User Profile">
                                            <?php else: ?>
                                            <img id="user_profile_preview" style="width:250px;height:250px;" src="<?php echo e(asset('dist/img/profile_avatar.png')); ?>" alt="User Profile">
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <img id="user_profile_preview" style="width:250px;height:250px;" src="<?php echo e(asset('dist/img/profile_avatar.png')); ?>" alt="User Profile">
                                        <?php endif; ?>
                                        <video id="user_profile_video" autoplay="true" style="width:250px;height:250px;display:none;"></video>
                                    </div>
                                    <div id="btn_group_one">
                                        <button type="button" class="btn btn-outline-dark" id="upload_btn">
                                            <i class="fas fa-upload"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-dark" id="camera_button">
                                            <i class="fas fa-camera"></i>
                                        </button>
                                        <?php if($canRemove): ?>
                                        <button type="button" class="btn btn-outline-danger" id="remove_btn">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        <?php endif; ?>
                                    </div>

                                    <div id="btn_group_two" style="display: none;">
                                        <button type="button" class="btn btn-outline-dark btn-sm" id="change_camera">
                                            <i class="material-icons">switch_camera</i>
                                        </button>
                                        <button type="button" class="btn btn-outline-dark btn-sm" id="retry_camera">
                                            <i class="material-icons">sync</i>
                                        </button>
                                        <button type="button" class="btn btn-outline-success" id="capture_btn">
                                            <i class="material-icons">camera</i>
                                        </button>
                                        
                                        <button type="button" class="btn btn-outline-danger btn-sm" id="close_camera">
                                            <i class="material-icons">close</i>
                                        </button>
                                    </div>
                                    <?php $__errorArgs = ['user_profile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="m-0 text-danger"><small><?php echo e($message); ?></small></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="address">Note/Address</label>
                                    <textarea name="note_address" id="" cols="30" rows="5" class="form-control form-control-sm" placeholder="Note/Address"><?php echo e($student->note_address); ?></textarea>
                                </div>

                                <div class="form-group mt-1">
                                    <label for="active_status">Active Status</label> <br/>
                                    <input
                                        type="checkbox"
                                        name="is_active"
                                        value="1"
                                        data-on="Active"
                                        data-off="Deactive"
                                        id="active_status"
                                        data-toggle="toggle" data-size="small"
                                        data-width="120"
                                        data-onstyle="success"
                                        data-offstyle="warning"
                                        <?php if($student->is_active): ?> checked <?php endif; ?>
                                    />
                                </div>

                            </div>

                        </div>

                        <div class="form-group mt-3">
                            <button type="submit" class="btn btn-dark">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
<link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet"/>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>

<script src="<?php echo e(asset('camera/camera.js')); ?>"></script>
<script>
    $(document).ready(function(){
        $('#upload_btn').on('click', function(){
            $("#user_profile").trigger('click');
        });

        $('#batch').on("change", function(){
            let id = $(this).val();
            $('#class').val($("#batch option[value='"+id+"']").data("class"));
        });

        $('#user_profile').on('change', function(){
            if (this.files && this.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#user_profile_preview').attr('src', e.target.result);
                    $('#camera_phone_input').val(''); // set camera input value null
                }
                reader.readAsDataURL(this.files[0]);
            }
        });

        // camera button group hide
        $('#btn_group_two').hide();

        $('#camera_button').on('click', function(){
            $('#btn_group_one').hide();
            $('#btn_group_two').show();
        });

        // close camer
        $('#close_camera').on('click', function(){
            $('#btn_group_one').show();
            $('#btn_group_two').hide();
        });

        $('#remove_btn').on('click', function(){
            if(confirm('Are you sure to remove this image?')){
                $.ajax({
                    url: "<?php echo e(route('students.remove_image', ['student' => $student])); ?>",
                    type: 'POST',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        _method: 'DELETE'
                    },
                    success: function(response){
                        if(response.success){
                            location.reload();
                        }
                        else{
                            alert(response.text);
                            return false;
                        }
                    }
                });
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/smartcm/resources/views/pages/students/edit.blade.php ENDPATH**/ ?>