<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(route('dashboard')); ?>" class="brand-link text-center">
        <span class="brand-text font-weight-light"><b><?php echo e(config('app.name')); ?></b></span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <img src="<?php echo e(asset('dist/img/profile_avatar.png')); ?>" class="img-circle elevation-2" alt="User Image">
            </div>
            <div class="info">
                <a href="javascript:void(0)" class="d-block"><?php echo e(auth()->user()->name); ?></a>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <!-- Add icons to the links using the .nav-icon class
                     with font-awesome or any other icon font library -->
                <li class="nav-item">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link">
                        <i class="nav-icon fas fa-th"></i>
                        <p>
                            Dashboard
                            
                        </p>
                    </a>
                </li>

                
                

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['payment-index', 'payment-create', 'payment-update', 'payment-destroy'])): ?>
                    <li class="nav-item">
                        <a href="javascript:void(0)" class="nav-link">
                            <i class="nav-icon fas fa-credit-card"></i>
                            <p>
                                Payments
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment-index')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('payments.index')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        Payment List
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check("payment-create")): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('payments.create')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        Add Payment
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check("payment-create")): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('payments.quick')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        Quick Payment
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <li class="nav-item">
                    <a href="javascript:void(0)" class="nav-link">
                        <i class="nav-icon fas fa-credit-card"></i>
                        <p>
                            Online Payments
                            <i class="right fas fa-angle-left"></i>
                            <?php if($online_payment_count > 0): ?>
                                <i class="right fa fa-bell text-danger"></i>
                            <?php endif; ?>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('payments.online_payment')); ?>" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Online Payment List <?php if($online_payment_count > 0): ?>
                                        <span class="badge badge-warning"><?php echo e($online_payment_count); ?></span>
                                    <?php endif; ?></p>
                            </a>
                        </li>
                    </ul>
                </li>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['student-index', 'student-create', 'student-update', 'student-destroy'])): ?>
                    <li class="nav-item">
                        <a href="javascript:void(0)" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <p>
                                Students
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-index')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('students.index')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Student List</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-create')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('students.create')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add Student</p>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['user-index', 'user-create', 'user-update', 'user-destroy', 'miscellaneous-user_permission'])): ?>
                    <li class="nav-item">
                        <a href="javascript:void(0)" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <p>
                                Users
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-index')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('users')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>User List</p>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-create')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('users.create')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add User</p>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any([
                  'miscellaneous-custom_sms_send', 'miscellaneous-sms_history', 'miscellaneous-sms_template', 'miscellaneous-sms_buy',
                  'sms-index', 'sms-create', 'sms-destroy', 'sms-update',
                ])): ?>
                    <li class="nav-item">
                        <a href="javascript:void(0)" class="nav-link">
                            <i class="nav-icon fas fa-sms"></i>
                            <p>
                                SMS
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-custom_sms_send')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route("custom_sms_send")); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Custom SMS Send</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-sms_history')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route("sms.history")); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>SMS History</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-sms_template')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route("sms.template")); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>SMS Template</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-sms_buy')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route("sms_buy")); ?>" target="_blank" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Buy SMS</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            

                            
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['report-student', 'report-payment'])): ?>
                    <li class="nav-item">
                        <a href="javascript:void(0)" class="nav-link">
                            <i class="nav-icon fas fa-file"></i>
                            <p>
                                Reports
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report-student')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route("report.student")); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Student Report</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report-payment')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('report.payment')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Payment Report</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('report-student_payment')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('report.student_payment')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Student Payment Report</p>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>


                
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any([
                  'batch-index', 'batch-crate', 'batch-update', 'batch-destroy',
                  'miscellaneous-general_setting', 'miscellaneous-institution_setting'
                ])): ?>
                    <li class="nav-item">
                        <a href="javascript:void(0)" class="nav-link">
                            <i class="nav-icon fas fa-cogs"></i>
                            <p>
                                Settings
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-institution_setting')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('settings.institution')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Institution Settings</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            
                            

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('batch-index')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('batch.index')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Batch List</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('batch-create')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('batch.create')); ?>" class="nav-link">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>Add Batch</p>
                                    </a>
                                </li>
                            <?php endif; ?>

                        </ul>
                    </li>
                <?php endif; ?>
            </ul>
        </nav>

        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
<?php /**PATH /var/www/html/CoachingManagement/resources/views/layouts/sidebar.blade.php ENDPATH**/ ?>