<?php $__env->startSection('title', 'Send SMS'); ?>

<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Send SMS</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('admin')); ?>">Admin</a>
                </li>
                <li class="breadcrumb-item active">
                    Send SMS
                </li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
    
    <div class="row">
        <div class="col-md-12 col-sm-12 m-auto">
            <div class="card">
                <div class="card-header bg-light">
                    <h4 class="card-title">Send Institution SMS</h4>
                </div>
                <div class="card-body overflow-auto">
                    <form action="<?php echo e(route('institution.send_sms')); ?>" method="GET">
                        <input type="hidden" name="send" value="1" />
                        <div class="form-group">
                            <label>Message</label>
                            <textarea class="form-control" name="message" cols="5" rows="3" placeholder="Write Message" required><?php echo e(request()->message); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label>Phone</label>
                            <input type="text" name="phone" class="form-control" placeholder="Search Phone" value="<?php echo e(request()->phone); ?>" />
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-sm btn-info">Search</button>
                            <?php if(request()->send): ?>
                                <a class="btn btn-sm btn-danger" href="<?php echo e(route('institution.send_sms')); ?>">Clear</a>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php if(request()->send): ?>
<form action="<?php echo e(route('institution.send_sms_submit')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Send SMS List</h4>
                </div>
                <div class="card-body">
                    <table class="table table-sm table-bordered">
                        <thead>
                            <tr>
                                <th class="text-center">
                                    <div class="icheck-success border-success">
                                        <input type="checkbox" name="check_all" id="check_all"/>
                                        <label for="check_all"></label>
                                    </div>
                                </th>
                                <th class="text-center">SL</th>
                                <th>Ins. Name</th>
                                <th>Phone</th>
                                <th>Message</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if($institutions->isNotEmpty()): ?>
                                <?php $__currentLoopData = $institutions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $institution): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-center">
                                            <div class="icheck-success border-success">
                                                <input type="checkbox" name="selected_id[]" value="<?php echo e($institution->id); ?>" id="selected_id<?php echo e($institution->id); ?>"/>
                                                <label for="selected_id<?php echo e($institution->id); ?>"></label>
                                            </div>
                                        </td>
                                        <td class="text-center"><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($institution->name); ?></td>
                                        <td><?php echo e($institution->phone); ?></td>
                                        <td>
                                            <?php echo e(request()->message); ?>

                                            <input type="hidden" name="message[]" value="<?php echo e(request()->message); ?>" />
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <button class="btn btn-sm btn-primary" type="submit">Send</button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php endif; ?>
    
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>"/>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    
   
<?php $__env->stopPush(); ?>

<?php if(session()->has('success')): ?>
<script>
    Toast.fire({
        icon: 'success', 
        text: '<?php echo e(session("success")); ?>',
    });
</script>
<?php endif; ?>



<?php $__env->startPush('js'); ?>
    <script>
      
        $(document).ready(function(){
            $('#check_all').on('change', function(){
                if($(this).is(":checked")) {
                    $('input[name="selected_id[]"]').each(function(index, element) {
                        $(element).prop('checked', true);
                    });
                }else {
                    $('input[name="selected_id[]"]').each(function(index, element) {
                        $(element).prop('checked', false);
                    });
                }
            })
        });

    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.super_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spanmmdr/smartqb.info/resources/views/pages/admin/institution/send_sms.blade.php ENDPATH**/ ?>