<?php $__env->startSection('title', 'General Settings'); ?>

<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">General Settings</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item ">
                    <a href="<?php echo e(route('admin')); ?>">Admin</a>
                </li>
                <li class="breadcrumb-item active">General Settings</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">General Settings</h4>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('settings.general_store')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="institution_id" value="<?php echo e($setting->institution_id); ?>"/>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="website_title">Website Title</label>
                                    <input type="text" name="title" value="<?php echo e($setting->title); ?>" id="website_title" class="form-control" placeholder="Website Title"/>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="user_manual">User Manual Link</label>
                                    <input type="url" name="user_manual_file_link" value="<?php echo e($setting->user_manual_file_link); ?>" id="user_manual" class="form-control" placeholder="User Manual File Link"/>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="facebook">Facebook</label>
                                    <input type="text" name="facebook" value="<?php echo e($setting->facebook); ?>" id="facebook" placeholder="Facebook" class="form-control"/>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="phone">Phone Number</label>
                                    <input type="tel" name="phone" value="<?php echo e($setting->phone); ?>" id="phone" placeholder="Phone Number" class="form-control"/>
                                </div>
                            </div>
                            
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="phone">Currency</label><br/>
                                    <div class="icheck-primary d-inline">
                                        <input type="radio" id="bdt" value="BDT" name="currency" <?php if($setting->currency =='BDT'): ?> checked <?php endif; ?>>
                                        <label for="bdt">
                                            BDT
                                        </label>
                                    </div>
                                    <div class="icheck-primary d-inline">
                                        <input type="radio" id="usd" value="USD" name="currency" <?php if($setting->currency=='USD'): ?> checked <?php endif; ?>>
                                        <label for="usd">
                                            USD
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="active_sms">Active SMS</label><br/>
                                    <input 
                                        type="checkbox" 
                                        name="active_sms" 
                                        value="1" 
                                        data-toggle="toggle"
                                        data-onstyle="success"   
                                        data-offstyle="warning"
                                        <?php if($setting->active_sms): ?> checked <?php endif; ?>  
                                    />
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="email">E-mail</label><br/>
                                    <input type="email" value="<?php echo e($setting->email); ?>" name="email" placeholder="E-mail" class="form-control">
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="timezone">TimeZone</label><br/>
                                    <select name="timezone" id="timezone" class="form-control" >
                                        <option value="" hidden>Select TimeZone</option>
                                        <?php $__currentLoopData = ['Asia/Dhaka', 'Asia/Kolkata']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($timezone); ?>" <?php if($setting->timezone == $timezone): ?> selected <?php endif; ?> ><?php echo e($timezone); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6 col-sm-12">
                                <div class="form-group">
                                    <label for="address">Address</label><br/>
                                    <textarea name="address" id="address" cols="30" rows="5" class="form-control"><?php echo e($setting->address); ?></textarea>
                                </div>
                            </div>

                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="is_maitanence_mood">Maintainence Mood</label>
                                    <input 
                                        type="checkbox" 
                                        name="is_maitanence_mood" 
                                        value="1" 
                                        id="is_maitanence_mood"
                                        data-toggle="toggle"
                                        data-onstyle="success"   
                                        data-offstyle="warning" 
                                        data-on="Active" 
                                        data-off="Deactive"
                                        <?php if($setting->is_maitanence_mood): ?> checked <?php endif; ?>  
                                    />
                                    <p class="text-danger"><u>N:T: User can't access the site when it's turn active.</u></p>
                                </div>
                            </div>

                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-dark">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
    <!-- Bootstrap Switch -->
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
    
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.super_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spanmmdr/smartqb.info/resources/views/pages/admin/settings/index.blade.php ENDPATH**/ ?>