<?php $__env->startSection('title', 'User List'); ?>


<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Users List</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item "><a href="<?php echo e(route("dashboard")); ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">User List</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-sm-12">
        
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">User List</h4>
            </div>
            <div class="card-body">
               
                <table id="user_list" class="table table-striped table-bordered">
                    <thead>
                        <tr class="text-center">
                            <th>SL</th>
                            <th>Name</th>
                            <th>Institution</th>
                            <th>Phone</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-show_psw')): ?>
                            <th>Password</th>
                            <?php endif; ?>
                            <th>E-mail</th>
                            <th>Role</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>
                                <?php echo e($user->name); ?> <?php if($user->active_status): ?><span class="badge badge-success">Active</span><?php else: ?>
                                <span class="badge badge-danger">Inactive</span><?php endif; ?>
                                <br/><small class="text-success"><i><?php echo e($user->level); ?></i></small>
                            </td>
                            <td><?php echo e($user->institution->name ?? "N/A"); ?></td>
                            <td>
                                <?php echo e($user->phone ?? "N/A"); ?>

                                <?php if($user->phone): ?>
                                    <span 
                                        data-toggle="tooltip" 
                                        data-placement="top" 
                                        title="Copy to Clipboard" 
                                        class="badge badge-light copy_text" 
                                        data-text="<?php echo e($user->phone); ?>" 
                                        role="button"
                                    >
                                        <i class="fa fa-copy"></i>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-show_psw')): ?>
                            <td>
                                <?php echo e($user->raw_psw ?? "N/A"); ?>

                                <?php if($user->raw_psw): ?>
                                    <span 
                                        data-toggle="tooltip" 
                                        data-placement="top" 
                                        title="Copy to Clipboard" 
                                        class="badge badge-light copy_text" 
                                        data-text="<?php echo e($user->raw_psw); ?>" 
                                        role="button"
                                    >
                                        <i class="fa fa-copy"></i>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <?php endif; ?>
                            <td><?php echo e($user->email ?? "N/A"); ?></td>
                            <td><?php echo e($user->roles->pluck('name')->first() ?? "N/A"); ?></td>
                            <td class="text-center">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['user-index', 'user-create', 'user-update', 'user-destroy'])): ?>
                                
                                <form id="destroy-<?php echo e($user->id); ?>" action="<?php echo e(route('users.destroy', ['user' => $user->id])); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                </form>
                                
                                <div class="btn-group dropleft">
                                    <button type="button" class="btn btn-outline-dark btn-xs dropdown-toggle dropdown-icon" data-toggle="dropdown">
                                      Action <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <div class="dropdown-menu" role="menu">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-index')): ?>
                                        <a class="dropdown-item show_btn" href="javascript:void(0)" data-link="<?php echo e(route("users.show", ['user' => $user->id])); ?>"><i class="fas fa-eye"></i> View</a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-update')): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('users.edit', ['user' => $user->id])); ?>"><i class="fas fa-edit"></i> Edit</a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-user_permission')): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('users.permission', ['user' => $user->id])); ?>"><i class="fas fa-lock"></i> Assign Permissoin</a>
                                        <?php endif; ?> 
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-destroy')): ?>
                                        <button type="button" class="dropdown-item delete_btn" data-id="<?php echo e($user->id); ?>"><i class="fas fa-trash"></i> Delete</button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
               
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    
    <script src="<?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/jszip/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/pdfmake/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/pdfmake/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(function () {
            $("#user_list").DataTable({
            "responsive": true, "lengthChange": false, "autoWidth": false,
            "buttons": [
                "csv", "excel", "pdf","print", "colvis"
            ],
            }).buttons().container().appendTo('#user_list_wrapper .col-md-6:eq(0)');
        });

        $(document).ready(function(){
            $('.copy_text').on("click", function(){
                navigator.clipboard.writeText($(this).data('text')).then(() => {
                    $(this).attr('data-original-title', 'Copied').tooltip('show');
                    $(this).attr('data-original-title', 'Copy to Clipboard').tooltip('update');
                });
            });
            // delete user
            $('.delete_btn').on('click', function(){
                let id = $(this).data('id');
                Swal.fire({
                    title: 'Are you sure to Delete?',
                    text: "You won't be able to undo this.",
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#destroy-'+id).submit();
                    }
                })
            });

            // show user
            $('.show_btn').on('click', function(){
                let loading_spinner = `<div class="d-flex justify-content-center">
                        <div class="spinner-border" style="width: 3rem; height: 3rem;" role="status">
                          <span class="sr-only">Loading...</span>
                        </div>
                    </div>`;
                
                let url = $(this).data('link');
                let request = $.ajax({
                    url: url,
                    method: "GET",
                    beforeSend: function( xhr ) {
                        $('#view_modal').modal('show');
                        $('#view_title').text('User Details');
                        $('#view_body').html(loading_spinner);
                    },
                    success: function(data) {
                        $('#view_body').html("");
                        $('#view_body').html(data);
                    }
                });

                request.fail(function( jqXHR, textStatus ) {
                    $('#view_body').html("");
                    $('#view_body').html(textStatus);
                });
            });

        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/smartcm/resources/views/pages/users/index.blade.php ENDPATH**/ ?>