<?php $__env->startSection('title', 'User Admin Permission'); ?>

<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Admin</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route("admin")); ?>">Admin</a>
                </li>
                <li class="breadcrumb-item active">User Admin Permission</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <form action="<?php echo e(route("user.admin.per.store", ['role' => $role->id])); ?>" method="post">
                <?php echo csrf_field(); ?>
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Assign Role Permission - (<b><u><?php echo e($role->name); ?></u></b>)</h4>
                </div>
                <div class="card-body">
                
                    <table class="table table-striped">
                        <thead>
                            <tr class="text-center">
                                <th>Module</th>
                                <th>All</th>
                                <th>Read</th>
                                <th>Create</th>
                                <th>Update</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $permission_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="text-center">
                                <td>
                                    <?php echo e(ucfirst($item)); ?>

                                </td>
                                <td>
                                    <input 
                                        type="checkbox" 
                                        id="<?php echo e($item . '-checked'); ?>"
                                        data-item="<?php echo e($item); ?>"
                                        data-toggle="toggle" data-size="small"
                                        data-onstyle="success"                                               
                                        data-offstyle="warning"   
                                        <?php if(in_array(
                                            $item.'-index', $permissions) && 
                                            in_array($item.'-create', $permissions) && 
                                            in_array($item.'-update', $permissions) && 
                                            in_array($item.'-destroy', $permissions)
                                        ): ?> 
                                            checked 
                                        <?php endif; ?>
                                        data-width="60px"
                                    />
                                </td>
                                <td>
                                    <input 
                                        type="checkbox" 
                                        name="<?php echo e('permission['.$item.'][]'); ?>" 
                                        value="<?php echo e($item.'-index'); ?>" 
                                        id="<?php echo e($item.'-index'); ?>" 
                                        data-toggle="toggle" data-size="small"
                                        data-onstyle="success"                                               
                                        data-offstyle="warning"   
                                        <?php if(in_array($item.'-index', $permissions)): ?> checked <?php endif; ?>
                                        data-width="60px"
                                    />
                                    
                                </td>
                                <td>
                                    <input 
                                        type="checkbox" 
                                        name="<?php echo e('permission['.$item.'][]'); ?>" 
                                        value="<?php echo e($item.'-create'); ?>" 
                                        id="<?php echo e($item.'-create'); ?>" 
                                        data-toggle="toggle" data-size="small"
                                        data-onstyle="success"   
                                        data-offstyle="warning"   
                                        <?php if(in_array($item.'-create', $permissions)): ?> checked <?php endif; ?>
                                        data-width="60px"
                                    />
                                </td>
                                <td>
                                    <input 
                                        type="checkbox" 
                                        name="<?php echo e('permission['.$item.'][]'); ?>" 
                                        value="<?php echo e($item.'-update'); ?>" 
                                        id="<?php echo e($item.'-update'); ?>" 
                                        data-toggle="toggle" data-size="small"
                                        data-onstyle="success"   
                                        data-offstyle="warning"   
                                        <?php if(in_array($item.'-update', $permissions)): ?> checked <?php endif; ?>
                                        data-width="60px"
                                    />
                                </td>
                                <td>
                                    <input 
                                        type="checkbox" 
                                        name="<?php echo e('permission['.$item.'][]'); ?>" 
                                        value="<?php echo e($item.'-destroy'); ?>" 
                                        id="<?php echo e($item.'-destroy'); ?>" 
                                        data-toggle="toggle" data-size="small"
                                        data-onstyle="success"   
                                        data-offstyle="warning" 
                                        <?php if(in_array($item.'-destroy', $permissions)): ?> checked <?php endif; ?>  
                                        data-width="60px"
                                    />
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <hr/>
                    <table class="table table-striped">
                        <tbody class="text-center">
                            <?php $__currentLoopData = $other_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sub_permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $sub_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_sub_permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(ucfirst($key)); ?></td>
                                    <?php $__currentLoopData = $sub_sub_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_key => $sub_sub_permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($sub_sub_permission)): ?>
                                            <td>
                                                <?php if(is_string($sub_key)): ?>
                                                    <?php echo e($sub_key); ?>

                                                <?php else: ?>
                                                    <?php echo e(ucfirst(str_replace("_", " ", $sub_sub_permission))); ?> <?php echo e(ucfirst($key)); ?>

                                                <?php endif; ?>
                                            </td>
                                        <?php else: ?>
                                            <td>&nbsp;</td>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <tr>
                                    <td>&nbsp;</td>
                                    <?php $__currentLoopData = $sub_sub_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_key => $sub_sub_permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($sub_sub_permission)): ?>
                                            <td>
                                                <input 
                                                    type="checkbox" 
                                                    name="<?php echo e('permission['.$key.'][]'); ?>" 
                                                    value="<?php echo e($key.'-'.$sub_sub_permission); ?>"
                                                    data-toggle="toggle" data-size="small"
                                                    data-onstyle="success"                                               
                                                    data-offstyle="warning"   
                                                    <?php if(in_array($key.'-'.$sub_sub_permission, $permissions)): ?> checked <?php endif; ?>  
                                                    data-width="60px"
                                                />
                                            </td>
                                        <?php else: ?> 
                                            <td>&nbsp;</td>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                    
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        </tbody>
                    </table>
                </div>
                <div class="card-footer text-right">
                    <button type="submit" class="btn btn-dark">Save Permission</button>
                </div>
            </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet"/>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
    <!-- Bootstrap Switch -->
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
<script>
    $(document).ready(function(){
        var roles = <?php echo json_encode($permission_list); ?>;
        roles.forEach(function(role){
            $('#'+role+'-checked').on('change', function(){
                var list = ['index', 'create', 'update', 'destroy'];
                if($(this).is(':checked')) {
                    list.forEach(function(item) {
                        if(!$('#'+role+'-'+item).is(':checked')) {
                            $('#'+role+'-'+item).bootstrapToggle('on');
                        }
                    });
                }else {
                    list.forEach(function(item) {
                        if($('#'+role+'-'+item).is(':checked')) {
                            $('#'+role+'-'+item).bootstrapToggle('off');
                        }
                    });
                }
            })
        });
        
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.super_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/smartcm/resources/views/pages/admin/settings/admin_permission.blade.php ENDPATH**/ ?>