<?php $__env->startSection('title', 'Batch List'); ?>

<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Batch List</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                </li>
                <li class="breadcrumb-item active">Batch</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Batch List</h4>
                </div>
                <div class="card-body">
                    <div class="col-md-12 col-sm-12">
                        <div style="overflow-x: auto">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Batch Name</th>
                                    <th>Batch Type</th>
                                    <th>Fee</th>
                                    <th>Batch Year</th>
                                    <th>Batch Class</th>
                                    <th>Batch Start</th>
                                    <th>Ins. Name</th>
                                    <th>Total Student</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if($batches->isEmpty()): ?>
                                    <tr>
                                        <td colspan="9" class="text-center">No Batch Found</td>
                                    </tr>
                                <?php endif; ?>

                                <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key + 1); ?></td>
                                        <td><?php echo e($batch->batch_name); ?></td>

                                        <td>
                                            <?php if($batch->batch_type == 1): ?>
                                                Monthly
                                            <?php elseif($batch->batch_type == 2): ?>
                                                Contract
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($batch->batch_fee); ?></td>
                                        <td><?php echo e($batch->batch_year); ?></td>
                                        <td><?php echo e($batch->batch_class); ?></td>
                                        <td>
                                            <?php if($batch->batch_start): ?>
                                                <?php echo e(date("M,y", strtotime($batch->batch_start . "-01"))); ?>

                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($batch->institution->name ?? "N/A"); ?> <br/>
                                            <?php if(auth()->user()->level == 'Super Admin'): ?>
                                            <span class="badge badge-info"><?php echo e($batch->institution->head_of_institution ?? "N/A"); ?>|<?php echo e($batch->institution->phone ?? "N/A"); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($batch->students_count); ?>

                                        </td>
                                        <td>
                                            <?php if($batch->is_active): ?>
                                                <span class="badge badge-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Deactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['batch-edit', 'batch-update', 'batch-destroy'])): ?>
                                            <div class="btn-group dropleft">
                                                <button type="button" class="btn btn-outline-dark btn-xs dropdown-toggle dropdown-icon" data-toggle="dropdown">
                                                Action <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu" role="menu">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('batch-index')): ?>
                                                    <a class="dropdown-item show_btn" href="javascript:void(0)" data-link="<?php echo e(route('batch.show', ['batch' => $batch->id])); ?>"><i class="fas fa-eye"></i> Show</a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('batch-update')): ?>
                                                    <a class="dropdown-item edit_btn" href="<?php echo e(route('batch.edit', ['batch' => $batch->id])); ?>"><i class="fas fa-edit"></i> Edit</a>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('batch-destroy')): ?>
                                                    <form id="destroy-<?php echo e($batch->id); ?>" action="<?php echo e(route('batch.destroy', ['batch' => $batch->id])); ?>" method="post">
                                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                    </form>
                                                    <button class="dropdown-item delete_btn" data-id="<?php echo e($batch->id); ?>" type="button"><i class="fas fa-trash"></i>  Delete</button>
                                                <?php endif; ?>
                                                </div>
                                            </div>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function(){
            let loading_spinner = `<div class="d-flex justify-content-center">
                        <div class="spinner-border" style="width: 3rem; height: 3rem;" role="status">
                          <span class="sr-only">Loading...</span>
                        </div>
                    </div>`;

            // view batch
            $('.show_btn').on('click', function(){
                let link = $(this).data('link');
                let request = $.ajax({
                    method: "GET",
                    url: link,
                    beforeSend: function(){
                        $('#view_modal').modal('show');
                        $('#view_title').text('Batch Details');
                        $('#view_body').html(loading_spinner);
                    },
                    success: function(data){
                        $('#view_body').html(data);
                    }
                });
                request.fail(function(xhr, status){
                    $('#view_body').html(status);
                });
            });

            // delete batch
            $('.delete_btn').on('click', function(){
                let id = $(this).data('id');
                Swal.fire({
                    title: 'Are you sure to Delete?',
                    text: "You won't be able to undo this. Will you deleted all information, which is related with batch?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#destroy-'+id).submit();
                    }
                })
            })

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/smartcm/resources/views/pages/batch/index.blade.php ENDPATH**/ ?>