<?php $__env->startSection('title', 'Student Payment History'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">  
    <?php if(auth()->guard('student')->user()->batch->batch_type == 1): ?>
    <div class="col-md-6 co-sm-12 m-auto overflow-auto">
      <?php if($student_payments->isNotEmpty()): ?>
      <table class="table table-sm table-bordered text-center">
        <caption>Student Payment Record</caption>
        <thead>
          <tr>
            <th>SL</th>
            <th>Month-Year</th>
            <th>Amount</th>
            <th>Discount</th>
            <th>Due</th>
            <th>Paid</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $student_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td><?php echo e(MONTH_LIST[$student_payment->pay_month]); ?>,<?php echo e($student_payment->pay_year); ?></td>
            <td><?php echo e($student_payment->need_to_pay ?? 0); ?></td>
            <td><?php echo e($student_payment->pay_discount ?? 0); ?></td>
            <td><?php echo e($student_payment->pay_due ?? 0); ?></td>
            <td><?php echo e($student_payment->pay_amount ?? 0); ?></td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
          <tr>
            <th class="text-center" colspan="3">Total</th>
            <th><?php echo e($student_payments->sum('pay_discount') ?? 0); ?></th>
            <th><?php echo e($student_payments->sum('pay_due') ?? 0); ?></th>
            <th><?php echo e($student_payments->sum('pay_amount') ?? 0); ?></th>
          </tr>
        </tfoot>
      </table>
      <?php else: ?>
      <p class="text-center text-danger">No Payment Found!</p>
      <?php endif; ?>
    </div>
    <?php else: ?> 
      <div class="col-md-6 col-sm-12 m-auto">
        <?php if($student_payments): ?>
        <table class="table table-sm table-bordered text-center">
          <caption>Student Payment Record</caption>
          <thead>
            <tr>
              <th style="width: 50%;">&nbsp;</th>
              <th style="width: 50%;">TK</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <th>Total Fee</th>
              <td><?php echo e($student_payments->need_to_pay ?? 0); ?></td>
            </tr>
            <tr>
              <th>Total Discount</th>
              <td><?php echo e($student_payments->pay_discount ?? 0); ?></td>
            </tr>
            <tr>
              <th>Total Paid</th>
              <td><?php echo e($student_payments->pay_amount ?? 0); ?></td>
            </tr>
          </tbody>
          <tfoot>
            <tr>
              <th>Total Due</th>
              <td><?php echo e($student_payments->pay_due ?? 0); ?></td>
            </tr>
          </tfoot>
        </table>
        <?php else: ?> 
        <p class="text-center text-danger">No Payment Found!</p>
        <?php endif; ?>
      </div>
    <?php endif; ?>
</div>
<div class="row">
  <div class="col-md-6 col-sm-12 m-auto overflow-auto">
    <table class="table table-sm table-bordered">
      <caption>Online Payment Pending List</caption>
      <thead>
        <tr>
          <th>SL</th>
          <th>Date</th>
          <th>Reference</th>
          <th>Name</th>
          <th>Payment Year</th>
          <th>Paid Amount</th>
          <th>Status</th>
          <th>&nbsp;</th>
        </tr>
      </thead>
      <tbody>
        <?php if($payment_histories->isNotEmpty()): ?>
          <?php $__currentLoopData = $payment_histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($loop->iteration); ?></td>
              <td><?php echo e(date('d/m/y', strtotime($payment_history->created_at))); ?></td>
              <td><?php echo e($payment_history->reference); ?></td>
              <td><?php echo e($payment_history->student->student_name); ?></td>
              <td><?php echo e($payment_history->payment_year); ?></td>
              <td><?php echo e($payment_history->paid_amount); ?></td>
              <td>
                <?php if(!$payment_history->is_approved): ?>  
                  <span class="badge badge-info">Pending</span>
                <?php endif; ?>
              </td>
              <td>
                <a href="<?php echo e(route('student_panel.invoice', ['reference' => $payment_history->reference])); ?>" class="btn btn-xs btn-success">
                  <i class="fa fa-eye"></i>
                </a>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.student_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/smartcm/resources/views/pages/student_panel/payment_history.blade.php ENDPATH**/ ?>