<table class="table table-striped">
    <tbody>
        <tr>
            <td colspan="3" class="text-center">
                <img src="<?php echo e($user_profile); ?>" width="80" height="80" class="img-rounded elevation-2" alt="User Image">
            </td>
        </tr>
        <tr>
            <td>Name: <?php echo e($student->student_name); ?></td>
            <td>Admission: <?php echo e(date('d-M,y', strtotime($student->admission_date))); ?></td>
            <td>Class: <?php echo e($student->student_class ?? "N/A"); ?></td>
        </tr>
        <tr>
            <td>Student Contact: <?php echo e($student->student_contact ?? "N/A"); ?></td>
            <td>Guardian Contact: <?php echo e($student->guardian_contact ?? "N/A"); ?></td>
            <td>College: <?php echo e($student->clg_name ?? "N/A"); ?></td>
        </tr>
        <tr>
            <td>Batch: <?php echo e($student->batch->batch_name ?? "N/A"); ?></td>
            <td>Institution: <?php echo e($student->institution->name ?? "N/A"); ?></td>
            <td>Active Status: <?php echo e($student->is_active ? "Active" : "Deactive"); ?></td>
        </tr>
        <tr>
            <td>Note</td>
            <td colspan="2"><?php echo e($student->note_address ?? "N/A"); ?></td>
        </tr>
    </tbody>
</table>

<h5 class="text-center text-success">Course Fee Details(Monthly/Contract)</h5>

<?php if($student->student_payment_details->isNotEmpty()): ?>
    
    <?php if($student->batch->batch_type == 1): ?>
    <table class="table table-bordered table-sm text-center">
        <thead>
            <tr>
                <th>Month-Year</th>
                <th>Payable Amount</th>
                <th>Discount</th>
                <th>Due</th>
                <th>Paid Amount</th>
            </tr>
        </thead>
        <tbody>
            
            <?php $__currentLoopData = $student->student_payment_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <?php echo e(date('M-y', strtotime($payment_detail->pay_year.'-'.($payment_detail->pay_month + 1).'-01'))); ?>

                    <?php if($payment_detail->is_paid): ?>
                        <span class="badge badge-success">Paid</span>
                    <?php else: ?> 
                        <span class="badge badge-danger">Due</span>
                    <?php endif; ?>
                </td>
                <td><?php echo e($payment_detail->need_to_pay); ?></td>
                <td><?php echo e($payment_detail->pay_discount); ?></td>
                <td><?php echo e($payment_detail->pay_due); ?></td>
                <td><?php echo e($payment_detail->pay_amount); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="2">Total</th>
                <th><?php echo e($student->student_payment_details->sum('pay_discount') ?? 0.00); ?></th>
                <th><?php echo e($student->student_payment_details->sum('pay_due') ?? 0.00); ?></th>
                <th><?php echo e($student->student_payment_details->sum('pay_amount') ?? 0.00); ?></th>
            </tr>
        </tfoot>
    </table>
    <?php elseif($student->batch->batch_type == 2): ?>
    <table class="table table-bordered table-sm text-center">
        <thead>
            <tr>
                <th>Year</th>
                <th>Payable Amount</th>
                <th>Discount</th>
                <th>Due</th>
                <th>Paid Amount</th>
            </tr>
        </thead>
        <tbody>
            
            <?php $__currentLoopData = $student->student_payment_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <?php echo e(date('Y', strtotime($payment_detail->pay_year.'-01-01'))); ?>

                    <?php if($payment_detail->is_paid): ?>
                        <span class="badge badge-success">Paid</span>
                    <?php else: ?> 
                        <span class="badge badge-danger">Due</span>
                    <?php endif; ?>
                </td>
                <td><?php echo e($payment_detail->need_to_pay); ?></td>
                <td><?php echo e($payment_detail->pay_discount ?? "0"); ?></td>
                <td><?php echo e($payment_detail->pay_due ?? 0); ?></td>
                <td><?php echo e($payment_detail->pay_amount ?? 0); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="2">Total</th>
                <th><?php echo e($student->student_payment_details->sum('pay_discount') ?? 0.00); ?></th>
                <th><?php echo e($student->student_payment_details->sum('pay_due') ?? 0.00); ?></th>
                <th><?php echo e($student->student_payment_details->sum('pay_amount') ?? 0.00); ?></th>
            </tr>
        </tfoot>
    </table>
    <?php endif; ?>
    
    <?php if($student->payments->isNotEmpty()): ?>
    <h5 class="text-center text-success">Payments Record</h5>
    <table class="table table-sm table-bordered text-center">
        <thead>
            <tr>
                <th>Ref. No</th>
                <th>Date</th>
                <th>Year</th>
                <th>Method</th>
                <th>Due</th>
                <th>Discount</th>
                <th>Total Amount</th>
                <th>Received By</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $student->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <a href="javascript:void(0)"><?php echo e($payment->ref_no); ?></a>
                </td>
                <td><?php echo e(date('d-M,y', strtotime($payment->payment_date))); ?></td>
                <td><?php echo e($payment->payment_year); ?></td>
                <td><?php echo e($payment->method == 1 ? "Cash" : "Other"); ?></td>
                <td><?php echo e($payment->due ?? 0); ?></td>
                <td><?php echo e($payment->discount ?? 0); ?></td>
                <td><?php echo e($payment->total_amount ?? 0); ?></td>
                <td><?php echo e($payment->payment_received->name ?? "N/A"); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="4">Total</th>
                <th><?php echo e($student->payments->sum('due') ?? 0); ?></th>
                <th><?php echo e($student->payments->sum('discount') ?? 0); ?></th>
                <th><?php echo e($student->payments->sum('total_amount') ?? 0); ?></th>
                <th>&nbsp;</th>
            </tr>
        </tfoot>
    </table>
    <?php endif; ?>
<?php else: ?> 
<p class="text-center text-danger">No Payment Record Found!</p>
<?php endif; ?>
<?php /**PATH /var/www/html/smartcm/resources/views/pages/students/show.blade.php ENDPATH**/ ?>