<?php $__env->startSection('title', 'Student Payment Report'); ?>

<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Student Payment Report</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item active">Student Payment Report</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Filter for Student Payment Report</h4>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                        </button>

                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                          <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>

                <div class="card-body">
                    <form action="<?php echo e(route('report.student_payment')); ?>" method="get">
                        <input type="hidden" name="filter" value="1">
                        <div class="form-row">
                            <div class="form-group col-md-3 col-sm-12">
                                <label for="payment_type">Payment Type</label>
                                <select name="payment_type" id="payment_type" class="form-control <?php $__errorArgs = ['payment_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="" hidden>Select Payment Type</option>
                                    <option value="paid" <?php echo e(old('payment_type') == 'paid' ? 'selected' : ''); ?>>Paid</option>
                                    <option value="unpaid" <?php echo e(old('payment_type') == 'unpaid' ? 'selected' : ''); ?>>Unpaid</option>
                                    <option value="due" <?php echo e(old('payment_type') == 'due' ? 'selected' : ''); ?>>Due</option>
                                </select>
                                <?php $__errorArgs = ['payment_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group col-md-3 col-sm-12">
                                <label for="batch">Select Batch</label>
                                <select name="batch" id="batch" class="form-control <?php $__errorArgs = ['batch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="" hidden>Select Batch</option>
                                    <?php if($batches->isNotEmpty()): ?>
                                        <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option data-type="<?php echo e($batch->batch_type); ?>" value="<?php echo e($batch->id); ?>"
                                                <?php echo e(old('batch') == $batch->id ? 'selected' : ''); ?>>
                                                <?php echo e($batch->batch_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['batch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block" role="alert"><strong><?php echo e($message); ?></strong></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group col-md-3 col-sm-12" id="student_list">
                                <label for="student">Select Student</label>
                                <select name="student" id="student" class="form-control <?php $__errorArgs = ['student'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <option value="" hidden>Select a Student</option>
                                    
                                    <?php if(old('student')): ?>
                                        <option value="<?php echo e(old('student')); ?>" selected>Selected Student</option>
                                    <?php endif; ?>
                                </select>
                                <?php $__errorArgs = ['student'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block" role="alert"><strong><?php echo e($message); ?></strong></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group col-md-3 col-sm-12" id="month_list">
                                <label for="month">Select Month</label>
                                <select name="month" id="month" class="form-control <?php $__errorArgs = ['month'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"></select>

                                <?php $__errorArgs = ['month'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block" role="alert"><strong><?php echo e($message); ?></strong></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>


                            <div class="form-group col-md-3 col-sm-12" id="year_list">
                                <label for="year">Select Year</label>
                                <select name="year" id="year" class="form-control <?php $__errorArgs = ['year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"></select>

                                <?php $__errorArgs = ['year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback d-block" role="alert"><strong><?php echo e($message); ?></strong></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-dark" type="submit">Search</button>
                            <a href="<?php echo e(route('report.student_payment')); ?>" class="btn btn-outline-danger float-right" type="reset">Clear</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <?php if($filter ?? false): ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <button id="print_report_btn" class="btn btn-dark btn-sm"><i class="fa fa-print"></i> Print</button>
                    <a href="javascript:void(0)" id="print_report_btn" class="btn btn-dark btn-sm">
                        <i class="fa fa-download"></i> Download PDF
                    </a>
                </div>
                <div class="card-body">
                    <div id="print_report">
                        <?php
                            $total_amount = 0;
                            $total_discount = 0;
                            $total_due = 0;
                        ?>
                        <table class="table table-sm table-bordered">
                            <thead class="text-center">
                                <tr>
                                    <th>SL</th>
                                    <th>Name</th>
                                    <th>Batch</th>
                                    <th>Class</th>
                                    <?php if($monthly): ?>
                                    <th>Month</th>
                                    <?php endif; ?>
                                    <?php if($yearly): ?>
                                        <th>Year</th>
                                    <?php endif; ?>
                                    <th>Amount</th>
                                    <th>Due</th>
                                    <th>Discount</th>
                                    <th>Paided</th>
                                </tr>
                            </thead>
                            <tbody class="text-center">
                                <?php $__empty_1 = true; $__currentLoopData = $student_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $total_amount += $student_payment->pay_amount ?? 0;
                                        $total_discount += $student_payment->pay_due ?? 0;
                                        $total_due += $student_payment->pay_discount ?? 0;
                                    ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($student_payment->student->student_name); ?>- <?php echo e($student_payment->student->id); ?></td>
                                        <td><?php echo e($student_payment->student->batch->batch_name); ?></td>
                                        <td><?php echo e($student_payment->student->student_class ?? "N/A"); ?></td>
                                        <?php if($monthly): ?>
                                        <td><?php echo e(MONTH_LIST[$student_payment->pay_month]); ?></td>
                                        <?php endif; ?>
                                        <?php if($yearly): ?>
                                            <td><?php echo e($student_payment->pay_year); ?></td>
                                        <?php endif; ?>
                                        <td><?php echo e($student_payment->pay_amount ?? 0); ?></td>
                                        <td><?php echo e($student_payment->pay_due ?? 0); ?></td>
                                        <td><?php echo e($student_payment->pay_discount ?? 0); ?></td>
                                        <td>
                                            <?php echo e($student_payment->is_paid === 1 ? 'Paid' : ($student_payment->is_paid === -1 ? 'Unpaid' : 'Due')); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9">No available data found!!!</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                            <tfoot class="text-center">
                                <tr>
                                    <th>Total</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <th>&nbsp;</th>
                                    <?php if($monthly || $yearly): ?>
                                    <th>&nbsp;</th>
                                    <?php endif; ?>
                                    <th><?php echo e($total_amount); ?></th>
                                    <th><?php echo e($total_discount); ?></th>
                                    <th><?php echo e($total_due); ?></th>
                                    <th>&nbsp;</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/select2/css/select2.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>"/>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
    
    <script>
        $('#month_list').hide();
        $('#year_list').hide();
        let isPrevValueSet = false;

        $(document).ready(function(){
            $('#print_report_btn').on('click', function(){
                printJS({
                    printable: "print_report",
                    type: 'html',
                    'css' : 'https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css'
                });
            });

            // batch
            $('#batch').select2({
                theme: 'bootstrap4',
                placeholder : "Select A Batch"
            });

            // student
            $('#student').select2({
                theme: 'bootstrap4',
                placeholder : "Select A Student"
            });

            // month
            $('#month').select2({
                theme: 'bootstrap4',
                placeholder : "Select a Month"
            });

            // year
            $('#year').select2({
                theme: 'bootstrap4',
                placeholder : "Select a Year"
            });

            $('#payment_type').select2({
                theme: 'bootstrap4',
                placeholder : "Select Payment Type"
            });

            $("#payment_type").on("change", function(){
                if ($(this).val() == "unpaid") {
                    $('#student_list').hide();
                    $('#student').val('');
                    // $('#month').val('').trigger('change');
                }
            });

            $('#batch').on('change', function () {
                let id = $(this).val();
                $('#month_list').val('');
                $('#year_list').val('');

                // Get batch type from selected option
                let type = $(`#batch option[value="${id}"]`).data('type');
                if (type == 1) {
                    $('#month_list').show();
                    $('#year_list').hide();
                } else {
                    $('#month_list').hide();
                    $('#year_list').show();
                }

                // Fetch students for selected batch via AJAX
                $.ajax({
                    url: `/dashboard/students/fetchBatchWise/${id}`,
                    type: 'GET',
                    success: function (response) {
                        if (response.status) {
                            let output = '<option value="" hidden>Select a Student</option>';
                            response.students.forEach(student => {
                                output += `<option value="${student.id}">${student.student_name}</option>`;
                            });

                            $('#student').html(output);
                            console.log('type', type);

                            if (type == 1) {
                                let monthOptions = '<option value="" hidden>Select a Month</option>';
                                response.monthList.forEach((month, index) => {
                                    monthOptions += `<option value="${index}">${month}</option>`;
                                });
                                $('#month').html(monthOptions);

                            } else {
                                let yearOptions = '<option value="" hidden>Select a Year</option>';
                                response.availableYear.forEach(year => {
                                    yearOptions += `<option value="${year}">${year}</option>`;
                                });
                                $('#year').html(yearOptions);
                            }

                            isPrevValueSet = false;
                            setTimeout(() => {
                                setPrevFilteredValue(true);
                            }, 100); // 100ms is usually enough
                        }
                        else {
                            $('#student').html('<option>No students found</option>');
                        }
                    },
                    error: function () {
                        $('#student').html('<option>No students found</option>');
                    }
                });
            });


            setPrevFilteredValue();
        });

        function setPrevFilteredValue(batchAjaxApplied = false) {
            if (!isPrevValueSet) {
                let batch = "<?php echo e(request('batch')); ?>";
                let student = "<?php echo e(request('student')); ?>";
                let month = "<?php echo e(request('month')); ?>";
                let year = "<?php echo e(request('year')); ?>";
                let payment_type = "<?php echo e(request('payment_type')); ?>";

                if(batch != "" && !batchAjaxApplied)
                {
                    $('#batch').val(batch).trigger("change");
                }

                if(student != "")
                {
                    $('#student').val(student).trigger('change');
                }

                if (month != "") {
                    $('#month').val(month).trigger('change');
                }

                if (year != "") {
                    $('#year').val(year).trigger('change');
                }

                if(payment_type != "")
                {
                    $('#payment_type').val(payment_type).trigger('change');
                }

                isPrevValueSet = true;
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/smartcm/resources/views/pages/reports/student_payment.blade.php ENDPATH**/ ?>