<?php $__env->startSection('title', 'Student Report'); ?>

<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Report</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item active">Student Report</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card <?php if($filter): ?> card-collapse <?php endif; ?>">
                <div class="card-header">
                    <h4 class="card-title">Filter for Student Report</h4>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                        </button>
                        
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                          <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('report.student')); ?>" method="get">
                        <input type="hidden" name="filter" value="yes">
                        <div class="form-row">
                            <div class="form-group col-md-4 col-sm-12">
                                <label for="batch">Select Batch</label>
                                <select name="batch_id" id="batch" class="form-control">
                                    <option value="" hidden>Select Batch</option>
                                    <?php if($batches->isNotEmpty()): ?>
                                    <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($batch->id); ?>"><?php echo e($batch->batch_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="form-group col-md-4 col-sm-12">
                                <label for="status">Active Status</label>
                                <select name="status" id="status" class="form-control">
                                    <option value="" hidden>Select Active Status</option>
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                            <div class="form-group col-md-4 col-sm-12">
                                <label for="admission_date">Admission Date</label>
                                <input type="date" name="admission_date" id="admission_date" class="form-control" />
                            </div>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-dark" type="submit">Search</button>
                            <a href="<?php echo e(route('report.student')); ?>" class="btn btn-outline-danger float-right" type="reset">Clear</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <?php if($filter): ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <button id="print_report_btn" class="btn btn-dark btn-sm"><i class="fa fa-print"></i> Print</button>
                    <a href="<?php echo e(route('report.student.pdf', request()->all())); ?>" id="print_report_btn" class="btn btn-dark btn-sm">
                        <i class="fa fa-download"></i> Download PDF
                    </a>
                </div>
                <div class="card-body">
                    <div id="print_report">
                        <table class="table table-sm table-bordered">
                            <thead class="text-center">
                                <tr>
                                    <th>SL</th>
                                    <th>Admission</th>
                                    <th>Name</th>
                                    <th>Contact</th>
                                    <th>Guardian Name</th>
                                    <th>Contact</th>
                                    <th>Batch</th>
                                    <th>Class</th>
                                </tr>
                            </thead>
                            <tbody class="text-center">
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e(date('d-M,y', strtotime($student->admission_date))); ?></td>
                                    <td><?php echo e($student->student_name); ?></td>
                                    <td><?php echo e($student->student_contact ?? "N/A"); ?></td>
                                    <td><?php echo e($student->guardian_name ?? "N/A"); ?></td>
                                    <td><?php echo e($student->guardian_contact ?? "N/A"); ?></td>
                                    <td><?php echo e($student->batch->batch_name ?? "N/A"); ?></td>
                                    <td><?php echo e($student->student_class); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
    
    <script>
        $(document).ready(function(){
            $('#print_report_btn').on('click', function(){
                printJS({
                    printable: "print_report", 
                    type: 'html',
                    'css' : 'https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css'
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spanmmdr/smartqb.info/resources/views/pages/reports/student.blade.php ENDPATH**/ ?>