<table class="table table-striped w-100">
    <tbody>
        <tr class="text-center">
            <th colspan="5">Payment Info. (<?php echo e($payment->payment_year); ?>)</th>
        </tr>
        <tr>
            <td colspan="2">Student Name: <?php echo e($payment->student->student_name); ?></td>
            <td colspan="2">Batch: <?php echo e($payment->student->batch->batch_name); ?></td>
            <td>Join Date: <?php echo e(date('d-M,y', strtotime($payment->student->admission_date))); ?></td>
        </tr>        
        <tr>
            <td colspan="2">Reference No: <b><?php echo e($payment->ref_no); ?></b></td>
            <td colspan="2">Payment Date: <b><?php echo e(date('d-M,y', strtotime($payment->payment_date))); ?></b></td>
            <td>Payment Method: <?php if($payment->method == 1): ?><b>Cash</b><?php endif; ?></td>
        </tr>
        <tr>
            <td colspan="2">Total Paid: <b><?php echo e($payment->total_amount ?? "N/A"); ?></b></td>
            <td colspan="2">Total Discount: <b><?php echo e($payment->discount ?? "N/A"); ?></b></td>
            <td>Total Due: <b><?php echo e($payment->due ?? "N/A"); ?></b></td>
        </tr>
        <tr class="text-center">
            <th>Month</th>
            <th>Fee</th>
            <th>Discount</th>
            <th>Due</th>
            <th>Paid</th>
        </tr>
        <?php if($payment->student->batch->batch_type == 1): ?>
            <?php $__currentLoopData = $payment->payment_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $month = $payment_detail->month+1;
                    $date = "{$payment->payment_year}-{$month}-01";
                ?>
                <tr class="text-center">
                    <td><?php echo e(date("M-y", strtotime($date))); ?></td>
                    <td><?php echo e($payment_detail->total_paidable()); ?></td>
                    <td><?php echo e($payment_detail->discount ?? "N/A"); ?></td>
                    <td><?php echo e($payment_detail->due ?? "N/A"); ?></td>
                    <td><?php echo e($payment_detail->amount ?? "N/A"); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if($payment->student->batch->batch_type == 2): ?>
            <?php $__currentLoopData = $payment->payment_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="text-center">
                    <td><?php echo e($payment->payment_year); ?></td>
                    <td><?php echo e($payment_detail->total_paidable()); ?></td>
                    <td><?php echo e($payment_detail->discount ?? "N/A"); ?></td>
                    <td><?php echo e($payment_detail->due ?? "N/A"); ?></td>
                    <td><?php echo e($payment_detail->amount ?? "N/A"); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <tr class="text-center">
            <th>Total</th>
            <th>&nbsp;</td>
            <th><?php echo e($payment->payment_details->sum('discount') ?? 0); ?></th>
            <th><?php echo e($payment->payment_details->sum('due') ?? 0); ?></th>
            <th><?php echo e($payment->payment_details->sum('amount') ?? 0); ?></th>
        </tr>
        <tr>
            <td>Note: </td>
            <td colspan="4" class="text-justify"><?php echo e($payment->note ?? "N/A"); ?></td>
        </tr>
        <tr>
            <td colspan="5">Payment Received By- <b><?php echo e($payment->payment_received->name); ?></b></td>
        </tr>
        <?php if($payment->updated_by): ?>
        <tr>
            <td colspan="5">Payment Updated By- <b><?php echo e($payment->payment_updated->name); ?></b></td>
        </tr>
        <?php endif; ?>
    </tbody>
</table><?php /**PATH /var/www/html/smartcm/resources/views/pages/payments/view.blade.php ENDPATH**/ ?>