<?php $__env->startSection('title', 'Add Payment'); ?>

<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Add Payment</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route("dashboard")); ?>">Dashboard</a>
                </li>
                <li class="breadcrumb-item active">Add Payment</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Add Payment</h4>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('payments.create')); ?>" method="GET">
                        <div class="row">
                            <div class="col-md-2 col-sm-12">
                                <div class="form-group">
                                    <label for="year">Select Year</label>
                                    <select name="year" id="year" class="form-control form-control-sm">
                                        <option value="" hidden>Select Year</option>
                                            <?php for($i = 0; $i <= 10; $i++): ?>
                                                <option <?php if($year == ($i+2020)): ?> selected <?php endif; ?> value="<?php echo e($i + 2020); ?>"><?php echo e($i + 2020); ?></option>
                                            <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="phone">Phone</label>
                                    <input type="tel" placeholder="Phone" name="phone" id="phone" class="form-control form-control-sm" value="<?php echo e(request('phone')); ?>" />
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-12">
                                <div class="form-group">
                                    <label for="batch">Select Batch</label>
                                    <select name="batch_id" id="batch" class="form-control form-control-sm">
                                        <option value="" hidden>Select Batch</option>
                                        <?php if($batches->isNotEmpty()): ?>
                                            <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($batch->id); ?>" <?php echo e(request('batch_id') == $batch->id ? 'selected': ''); ?>><?php echo e($batch->batch_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-12">
                                <div class="form-group">
                                    <label for="student">Select Student</label>
                                    <select name="student_id" id="student" class="form-control form-control-sm">
                                        <option value="" hidden>Select A Student</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group text-center">
                                    <button type="submit" class="btn btn-dark btn-sm">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>

                    <?php if(!is_null($student)): ?>

                        

                        <div class="row">
                            <div class="col-md-4 col-sm-12 p-2 rounded border">
                                <ul class="list-group list-group-flush ">
                                    <li class="list-group-item text-center">
                                        <b>Batch Info.</b>
                                    </li>
                                    <li class="list-group-item">Name: <u><?php echo e($student->batch->batch_name); ?> (<?php echo e($student->batch->batch_year); ?>)</u></li>
                                    <li class="list-group-item">
                                        Type:
                                        <?php if($student->batch->batch_type == 1): ?>
                                            <u>Monthly</u>
                                        <?php elseif($student->batch->batch_type == 2): ?>
                                            <u>Contract</u>
                                        <?php endif; ?>
                                    </li>
                                    <li class="list-group-item">Fee: <u><?php echo e($student->batch->batch_fee); ?></u></li>
                                    <li class="list-group-item">
                                        Batch Start:
                                        <?php if($student->batch->batch_start): ?>
                                            <u><?php echo e(date("M,y", strtotime($student->batch->batch_start . "-01"))); ?></u>
                                        <?php endif; ?>
                                    </li>
                                </ul>

                            </div>

                            
                            <div class="col-md-8 col-sm-12 p-2">
                                <form action="<?php echo e(route('payments.store')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="student_id" value="<?php echo e($student->id); ?>" />
                                    <input type="hidden" name="batch_type" value="<?php echo e($student->batch->batch_type); ?>" />
                                    <input type="hidden" name="batch_fee" value="<?php echo e($student->batch->batch_fee); ?>" />
                                    <input type="hidden" name="payment_year" value="<?php echo e($year); ?>" />
                                <table class="table table-striped">
                                    <thead>
                                        <tr class="text-center">
                                            <th colspan="2">Student Information</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Name: <u><?php echo e($student->student_name); ?></u></td>
                                            <td>Batch: <u><?php echo e($student->batch->batch_name); ?></u></td>
                                        </tr>
                                        <tr>
                                            <td>Class: <u><?php echo e($student->student_class ?? "N/A"); ?></u></td>
                                            <td>Institution: <u><?php echo e($student->institution->name ?? "N/A"); ?></u></td>
                                        </tr>
                                        <tr>
                                            <td>Total Paid: <?php echo e($student->get_paid_amount($year) ?? "N/A"); ?></td>
                                            <td>Total Due: <?php echo e($student->get_due_amount($year) ?? 0); ?></td>
                                        </tr>
                                        <tr>
                                            <td>Total Discount: <?php echo e(($student->batch->batch_fee - $student->get_paid_amount($year) - $student->get_due_amount($year)) ?? 0); ?></td>
                                            <td></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="alert alert-danger"><?php echo e($message); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="row">
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <label for="">Date</label>
                                            <input type="date" name="payment_date" value="<?php echo e(date("Y-m-d")); ?>" class="form-control form-control-sm"/>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-sm-12">
                                        <div class="form-group">
                                            <label for="">Ref. No</label>
                                            <input type="text" name="ref_no" class="form-control form-control-sm" placeholder="Ref. No"/>
                                        </div>
                                    </div>

                                    <?php if($student->batch->batch_type == 1): ?>
                                    <?php
                                        $arr = explode("-", $student->batch->batch_start);
                                        if($year == $arr[0])
                                            $month_start = ($arr[1] - 1) * 1;
                                        else
                                            $month_start = null;

                                        $admission_month = null;
                                        if($year == date('Y', strtotime($student->admission_date))) {
                                            $admission_month = (date('m', strtotime($student->admission_date)) -1) * 1;
                                        }

                                    ?>
                                    <div class="col-md-12 col-sm-12">
                                        <div class="form-group">
                                            <label for="select_month">Select Month</label>
                                            <select name="select_month[]" id="selct_month" tags="true" multiple="multiple" class="form-control form-control-sm" required>
                                                <option value="" hidden>Select Month</option>
                                                <?php $__currentLoopData = MONTH_LIST; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if((!is_null($month_start) && $month_start > $key) || (!is_null($admission_month) && $admission_month > $key)): ?>
                                                        <option value="<?php echo e($key); ?>" disabled><?php echo e($month); ?></option>
                                                    <?php else: ?>
                                                        <?php if(in_array($key, $student->get_payment_month($year))): ?>
                                                            <?php if($student->is_paid_this_month($year, $key)): ?>
                                                                <option value="<?php echo e($key); ?>" disabled><?php echo e($month); ?> - Paid</option>
                                                            <?php else: ?>
                                                                <option value="<?php echo e($key); ?>" data-fee="<?php echo e($student->get_due_amount($year, $key)); ?>"><?php echo e($month); ?> - Due</option>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <option data-fee="<?php echo e($student->batch->batch_fee); ?>" value="<?php echo e($key); ?>" ><?php echo e($month); ?></option>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <?php if($student->batch->batch_type == 1): ?>
                                    <div class="col-md-12 col-sm-12">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>&nbsp;</th>
                                                    <th>Fee</th>
                                                    <th>Amount</th>
                                                    <th>Discount</th>
                                                    <th>Due</th>
                                                </tr>
                                            </thead>
                                            <tbody id="input_container">

                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <td>&nbsp;</td>
                                                    <td id="total_sub_amount">0</td>
                                                    <td id="total_sub_pay_amount">0</td>
                                                    <td id="total_sub_discount">0</td>
                                                    <td id="total_sub_due">0</td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                    <?php endif; ?>

                                    <?php if($student->batch->batch_type == 2): ?>
                                        <input type="hidden" name="amount" value="<?php echo e($student->batch->batch_fee); ?>" />
                                        <input type="hidden" id="payment_due" value="<?php echo e($student->get_due_amount($year)); ?>" />
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label for="pay_amount">Amount</label>
                                                <input type="number" name="pay_amount" min="0" step="1" class="form-control form-control-sm"
                                                    id="pay_amount" placeholder="Amount" required />
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label for="discount">Discount</label>
                                                <input type="number" name="discount" min="0" step="1" class="form-control form-control-sm" id="discount" placeholder="Discount"/>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label for="due">Due</label>
                                                <input type="number" name="due" min="0" step="1" class="form-control form-control-sm" id="due" placeholder="Due"/>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    
                                    <div class="col-md-12 col-sm-12">
                                        <div class="form-group">
                                            <div class="icheck-primary d-inline">
                                                <input type="checkbox" id="send_sms" name="send_sms" >
                                                <label for="send_sms" class="
                                                <?php if(valid_sms() && total_sms() > 0): ?> text-success <?php else: ?> text-danger <?php endif; ?>
                                                ">
                                                    Send Payment SMS (<?php echo e(total_sms()); ?> Qty)
                                                    
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12 col-sm-12">
                                        <div class="form-group">
                                            <label for="">Payment Note</label>
                                            <textarea name="note" id="payment_note" cols="30" rows="3" class="form-control form-control-sm"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <hr/>
                                <?php if($student->batch->batch_type == 1): ?>
                                <input type="hidden" name="sub_amount" value="" required>
                                <input type="hidden" name="sub_discount" value="" >
                                <input type="hidden" name="sub_due" value="">
                                <?php endif; ?>
                                <input type="hidden" name="total_amount" value="" required>
                                <div class="row">
                                    <div class="col-md-3 col-sm-12">
                                        Total Fee: <u><span id="footer_subtotal">0.00</span> TK</u>
                                    </div>
                                    <div class="col-md-3 col-sm-12">
                                        Discount: <u><span id="footer_discount">0.00</span> TK</u>
                                    </div>
                                    <div class="col-md-3 col-sm-12">
                                        Due: <u><span id="footer_due">0.00</span> TK</u>
                                    </div>
                                    <div class="col-md-3 col-sm-12">
                                        Grand Total: <u><span id="footer_grand_total">0.00</span> TK</u>
                                    </div>
                                </div>
                                <hr/>
                                <div class="form-group mt-2 text-center">
                                    <button class="btn btn-dark" id="savePayment">Save</button>
                                </div>
                                </form>
                            </div>
                        </div>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/select2/css/select2.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/toastr/toastr.css')); ?>"/>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/icheck-bootstrap/3.0.1/icheck-bootstrap.min.css" integrity="sha512-8vq2g5nHE062j3xor4XxPeZiPjmRDh6wlufQlfC6pdQ/9urJkU07NM0tEREeymP++NczacJ/Q59ul+/K2eYvcg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<?php $__env->stopPush(); ?>


<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/toastr/toastr.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php if(!(valid_sms() && total_sms() > 0)): ?>
    <?php $__env->startPush('js'); ?>
    <script>
        $('#send_sms').on('change', function(){
            if($(this).is(':checked')){
                Swal.fire({
                    icon: "info",
                    title: "Please Buy SMS!",
                    text: "You don\'t have enough sms or validity. Please buy sms!",
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Buy SMS',
                    reverseButtons: true,
                    showCloseButton: true,
                }).then(res => {
                    if(res.isConfirmed) {
                        window.location.href = "<?php echo e(route('sms_buy')); ?>";
                    }else {
                        $('#send_sms').prop('checked', false);
                    }
                })
            }
        });
    </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>


<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function(){
            toastr.options.timeOut = 0;
            toastr.options.positionClass = "toast-top-center";

            // boostrap select 2
            $('#batch').select2({
                theme: 'bootstrap4',
                placeholder : "Select A Batch"
            });

            // toastr
            var toastr_ = null;

            $('#batch').on('change', function(){
                toastr_ = toastr.info('Please wait...');
                $.get(
                    "<?php echo e(route('payments.create')); ?>",
                    {
                        "batch_id": $(this).val(),
                    },
                    function(data, status) {
                        if(status == 'success') {
                            toastr_.remove();
                            $('#student').html('<option value="" hidden>Select A Student</option>');
                            $('#student').select2({
                                theme: "bootstrap4",
                                placeholder: "Select A Student",
                                data: data.students.map(function(item) {
                                    return {id: item.id, text: item.student_name}
                                }),
                            });
                        }
                    },
                ).fail(function() {
                    Swal.fire("Something Went Worng!");
                });
            });

            <?php if(!empty(request('batch_id'))): ?>
            $('#batch').trigger('change');

            setTimeout(()=>{
                <?php if(!empty(request('student_id'))): ?>
                    let studentId = '<?php echo e(request('student_id')); ?>';
                    $('#student').val(studentId).trigger('change');
                <?php endif; ?>
            }, 1000);
            <?php endif; ?>


        })
    </script>
<?php $__env->stopPush(); ?>

<?php if(!is_null($student) && $student->batch->batch_type == 2): ?>
    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function () {
                // Trigger calculation on blur of relevant fields
                $('#pay_amount, #discount, #due').on('blur', function () {
                    calculation($(this).attr('id')); // Pass the id of the field being modified
                });

                function calculation(modifiedField) {
                    let batchFee = parseInt($('input[name="batch_fee"]').val()) || 0;
                    let paymentDue = parseInt($('#payment_due').val()) || 0;
                    let amount = parseInt($('#pay_amount').val()) || 0;
                    let discount = parseInt($('#discount').val()) || 0;
                    let due = parseInt($('#due').val()) || 0;

                    let payableAmount = paymentDue > 0 ? paymentDue : batchFee;

                    if (modifiedField === 'pay_amount') {
                        if (amount > payableAmount) {
                            alert('Amount cannot exceed the payable amount!');
                            amount = payableAmount;
                            $('#pay_amount').val(amount).focus();
                        }

                        // Recalculate due and discount
                        due = payableAmount - amount;
                        discount = 0;
                    } else if (modifiedField === 'due') {
                        if (due > (payableAmount - amount)) {
                            alert('Due cannot exceed the maximum allowable due!');
                            due = payableAmount - amount;
                            $('#due').val(due).focus();
                        }

                        // Recalculate discount
                        discount = payableAmount - amount - due;
                    } else if (modifiedField === 'discount') {
                        if (discount > (payableAmount - amount)) {
                            alert('Discount cannot exceed the maximum allowable discount!');
                            discount = payableAmount - amount;
                            $('#discount').val(discount).focus();
                        }

                        // Recalculate due
                        due = payableAmount - amount - discount;
                    }

                    // Update input values
                    $('#pay_amount').val(amount);
                    $('#discount').val(discount);
                    $('#due').val(due);

                    // Update total amount
                    $('input[name="total_amount"]').val(amount);

                    // Update footer values
                    $('#footer_subtotal').text(payableAmount);
                    $('#footer_discount').text(discount);
                    $('#footer_due').text(due);
                    $('#footer_grand_total').text(amount);
                }
            });


        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php if(!is_null($student) && $student->batch->batch_type == 1): ?>
    <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function(){
                // set bootstrap select 2 in selec month field
                $('#selct_month').select2({
                    theme: 'bootstrap4',
                    placeholder : "Select Month"
                });

                $("#selct_month").on('change', function(){
                    let id = $(this).val();
                    var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                    var output = '';
                    var total_fee = 0;
                    id.forEach(item => {
                        let fee = $("#selct_month option[value='"+item+"']").data('fee');
                        total_fee += fee ? fee : 0;
                        output += '<tr><td>'+months[item]+'</td><td>';
                        output += '<input type="number" readonly name="amount['+item+']" min="0" step="1" value="'+fee+'" class="form-control form-control-sm amount"></td><td>';
                        output += '<input type="number" name="pay_amount['+item+']" min="0" step="1" value="0" class="form-control form-control-sm pay_amount"></td><td>';
                        output += '<input type="number" name="discount['+item+']" min="0" step="1" value="0" class="form-control form-control-sm discount"></td><td>';
                        output += '<input type="number" name="due['+item+']" min="0" step="1" value="0" class="form-control form-control-sm due"></td></tr>';
                    });
                    $('#input_container').html(output);
                    grand_total();
                });

                $(document).on('blur', '.pay_amount', function () {
                    let parent_tr = $(this).closest('tr');
                    let givenAmount = parseInt($(this).val()) || 0;
                    setAmountWithPriority(parent_tr, 'pay_amount', givenAmount);
                });

                $(document).on('blur', '.discount', function () {
                    let parent_tr = $(this).closest('tr');
                    let givenAmount = parseInt($(this).val()) || 0;
                    setAmountWithPriority(parent_tr, 'discount', givenAmount);
                });

                $(document).on('blur', '.due', function () {
                    let parent_tr = $(this).closest('tr');
                    let givenAmount = parseInt($(this).val()) || 0;
                    setAmountWithPriority(parent_tr, 'due', givenAmount);
                });

                function handleInputWithPriority(parent_tr, className) {
                    let givenAmount = parseInt(parent_tr.find('.' + className).val()) || 0;
                    let maxAmountForInput = calculateMaxAmount(parent_tr, className);

                    if (givenAmount > maxAmountForInput) {
                        parent_tr.find('.' + className).val(maxAmountForInput);
                        givenAmount = maxAmountForInput;
                    }

                    setAmountWithPriority(parent_tr, className, givenAmount);
                }

                function calculateMaxAmount(parent_tr, className) {
                    let fee = parseInt(parent_tr.find('.amount').val()) || 0;
                    let pay_amount = parseInt(parent_tr.find('.pay_amount').val()) || 0;
                    let discount = parseInt(parent_tr.find('.discount').val()) || 0;
                    let due = parseInt(parent_tr.find('.due').val()) || 0;

                    if (className === 'pay_amount') {
                        return fee - discount - due;
                    } else if (className === 'discount') {
                        return fee - pay_amount - due;
                    } else if (className === 'due') {
                        return fee - pay_amount - discount;
                    }
                }

                function setAmountWithPriority(parent_tr, className, givenAmount) {
                    let fee = parseInt(parent_tr.find('.amount').val()) || 0;
                    let pay_amount = parseInt(parent_tr.find('.pay_amount').val()) || 0;
                    let discount = parseInt(parent_tr.find('.discount').val()) || 0;
                    let due = parseInt(parent_tr.find('.due').val()) || 0;

                    let maxAllowed = fee;

                    if (className === 'pay_amount') {
                        if (givenAmount > fee) {
                            alert('Pay amount cannot exceed the total fee: ' + fee);
                            parent_tr.find('.pay_amount').val(maxAllowed).focus(); // Reset to previous value
                            return;
                        }

                        let remaining = fee - givenAmount;

                        if (discount > 0) {
                            discount = Math.min(discount, remaining);
                            remaining -= discount;
                        }

                        due = Math.max(remaining, 0);
                        parent_tr.find('.discount').val(discount);
                        parent_tr.find('.due').val(due);
                    } else if (className === 'discount') {
                        maxAllowed = fee - pay_amount - due;
                        if (givenAmount > maxAllowed) {
                            alert('Discount cannot exceed the maximum allowed: ' + maxAllowed);
                            parent_tr.find('.discount').val(maxAllowed).focus(); // Reset to previous value
                            return;
                        }

                        let remaining = fee - pay_amount - givenAmount;

                        due = Math.max(remaining, 0);
                        parent_tr.find('.due').val(due);
                        parent_tr.find('.discount').val(givenAmount);
                    } else if (className === 'due') {
                        maxAllowed = fee - pay_amount - discount;
                        if (givenAmount > maxAllowed) {
                            alert('Due amount cannot exceed the maximum allowed: ' + maxAllowed);
                            parent_tr.find('.due').val(maxAllowed).focus(); // Reset to previous value
                            return;
                        }

                        let remaining = fee - pay_amount - givenAmount;

                        discount = Math.max(remaining, 0);
                        parent_tr.find('.discount').val(discount);
                        parent_tr.find('.due').val(givenAmount);
                    }

                    parent_tr.find('.pay_amount').val(pay_amount);
                }


                // sum all amount, discount, due
                ['.amount', '.pay_amount', '.discount', '.due'].map(function(item) {
                    $(document).on('blur', item, function(){
                        grand_total();
                    });
                });

                function grand_total() {
                    let total_amount = 0;
                    $('.amount').each((index, item)=> {
                        total_amount += parseInt($(item).val() ? $(item).val() : 0);
                    });

                    let pay_fee = 0;
                    $('.pay_amount').each((index, item)=> {
                        pay_fee += parseInt($(item).val() ? $(item).val() : 0);
                    });


                    let total_discount = 0;
                    $('.discount').each((index, item)=> {
                        total_discount += parseInt($(item).val() ? $(item).val() : 0);
                    });

                    let total_due = 0;
                    $('.due').each((index, item)=> {
                        total_due += parseInt($(item).val() ? $(item).val() : 0);
                    });
                    // table footer
                    $('#total_sub_amount').text(Number(total_amount).toFixed(2));
                    $('#total_sub_pay_amount').text(Number(pay_fee).toFixed(2));
                    $('#total_sub_discount').text(Number(total_discount).toFixed(2));
                    $('#total_sub_due').text(Number(total_due).toFixed(2));

                    // footer
                    $('#footer_subtotal').text(Number(total_amount).toFixed(2));
                    $('#footer_discount').text(Number(total_discount).toFixed(2));
                    $('#footer_due').text(Number(total_due).toFixed(2));

                    // input value
                    $('input[name="total_amount"]').val(parseInt(total_amount - (total_discount + total_due)));
                    $('input[name="sub_discount"]').val(parseInt(total_discount));
                    $('input[name="sub_due"]').val(parseInt(total_due));
                    $('input[name="sub_amount"]').val(parseInt(total_amount));
                    // grand total
                    $('#footer_grand_total').text(Number(total_amount - (total_discount + total_due)).toFixed(2)); //

                }

            })

        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spanmmdr/smartqb.info/resources/views/pages/payments/create.blade.php ENDPATH**/ ?>