<table class="table table-striped">
    <thead>
        <tbody>
            <tr>
                <td>Name: <?php echo e($user->name); ?></td>
                <td>Phone: <?php echo e($user->phone); ?></td>
                <td>E-mail: <?php echo e($user->email); ?></td>
            </tr>
            <tr>
                <td>Status: <?php echo e($user->active_status ? "Active" : "Deactive"); ?></td>
                <td>Level: <?php echo e($user->level ?? "N/A"); ?></td>
                <td>&nbsp;</td>
            </tr>
        </tbody>
    </thead>
</table>
<h4 class="text-center">Permission List</h4>
<table class="table table-striped">
    <thead>
        <tr class="text-center">
            <th>Module</th>
            <th>All</th>
            <th>Read</th>
            <th>Create</th>
            <th>Update</th>
            <th>Delete</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $permission_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($user->canany([$item.'-index', $item.'-create', $item.'-update', $item.'-destroy'])): ?>
        <tr class="text-center">
            <td>
                <?php echo e(ucfirst($item)); ?>

            </td>
            <td>
                <input 
                    type="checkbox" 
                    id="<?php echo e($item . '-checked'); ?>"
                    data-item="<?php echo e($item); ?>"
                    data-toggle="toggle" data-size="small"
                    data-onstyle="success"                                               
                    data-offstyle="warning"   
                    <?php if(in_array(
                        $item.'-index', $permissions) && 
                        in_array($item.'-create', $permissions) && 
                        in_array($item.'-update', $permissions) && 
                        in_array($item.'-destroy', $permissions)
                    ): ?> 
                        checked 
                    <?php endif; ?>
                    data-width="60px"
                />
            </td>
            <td>
                <?php if($user->can($item.'-index')): ?>
                <input 
                    type="checkbox" 
                    name="<?php echo e('permission['.$item.'][]'); ?>" 
                    value="<?php echo e($item.'-index'); ?>" 
                    id="<?php echo e($item.'-index'); ?>" 
                    data-toggle="toggle" data-size="small"
                    data-onstyle="success"                                               
                    data-offstyle="warning"   
                    <?php if(in_array($item.'-index', $permissions)): ?> checked <?php endif; ?>
                    data-width="60px"
                />
                <?php else: ?>
                    N/A 
                <?php endif; ?>                                      
            </td>
            <td>
                <?php if($user->can($item.'-create')): ?>
                <input 
                    type="checkbox" 
                    name="<?php echo e('permission['.$item.'][]'); ?>" 
                    value="<?php echo e($item.'-create'); ?>" 
                    id="<?php echo e($item.'-create'); ?>" 
                    data-toggle="toggle" data-size="small"
                    data-onstyle="success"   
                    data-offstyle="warning"   
                    <?php if(in_array($item.'-create', $permissions)): ?> checked <?php endif; ?>
                    data-width="60px"
                />
                <?php else: ?> 
                    N/A 
                <?php endif; ?>
            </td>
            <td>
                <?php if($user->can($item.'-update')): ?>
                <input 
                    type="checkbox" 
                    name="<?php echo e('permission['.$item.'][]'); ?>" 
                    value="<?php echo e($item.'-update'); ?>" 
                    id="<?php echo e($item.'-update'); ?>" 
                    data-toggle="toggle" data-size="small"
                    data-onstyle="success"   
                    data-offstyle="warning"   
                    <?php if(in_array($item.'-update', $permissions)): ?> checked <?php endif; ?>
                    data-width="60px"
                />
                <?php else: ?> 
                    N/A 
                <?php endif; ?>
            </td>
            <td>
                <?php if($user->can($item.'-destroy')): ?>
                <input 
                    type="checkbox" 
                    name="<?php echo e('permission['.$item.'][]'); ?>" 
                    value="<?php echo e($item.'-destroy'); ?>" 
                    id="<?php echo e($item.'-destroy'); ?>" 
                    data-toggle="toggle" data-size="small"
                    data-onstyle="success"   
                    data-offstyle="warning" 
                    <?php if(in_array($item.'-destroy', $permissions)): ?> checked <?php endif; ?>  
                    data-width="60px"
                />
                <?php else: ?> 
                    N/A 
                <?php endif; ?>
            </td>
        </tr>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<hr/>
<table class="table table-striped">
    <tbody class="text-center">
        <?php $__currentLoopData = $other_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sub_permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $sub_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_sub_permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $per_items = [];
                foreach($sub_sub_permissions as $sub_key => $sub_sub_permission){
                    if(!empty($sub_sub_permission))
                        array_push($per_items, $key.'-'.$sub_sub_permission);

                }
            ?>
            <?php if($user->canany($per_items)): ?>
            <tr>
                <td><?php echo e(ucfirst($key)); ?></td>
                <?php $__currentLoopData = $sub_sub_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_key => $sub_sub_permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!empty($sub_sub_permission) && $user->can($key.'-'.$sub_sub_permission)): ?>
                        <td>
                            <?php if(is_string($sub_key)): ?>
                                <?php echo e($sub_key); ?>

                            <?php else: ?>
                                <?php echo e(ucfirst(str_replace("_", " ", $sub_sub_permission))); ?> <?php echo e(ucfirst($key)); ?>

                            <?php endif; ?>
                        </td>
                    <?php else: ?>
                        <td>N/A</td>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
            <tr>
                <td>&nbsp;</td>
                <?php $__currentLoopData = $sub_sub_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_key => $sub_sub_permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(!empty($sub_sub_permission)): ?>                    
                        <?php if($user->can($key.'-'.$sub_sub_permission)): ?>
                        <td>
                            <input 
                                type="checkbox" 
                                name="<?php echo e('permission['.$key.'][]'); ?>" 
                                value="<?php echo e($key.'-'.$sub_sub_permission); ?>"
                                data-toggle="toggle" data-size="small"
                                data-onstyle="success"                                               
                                data-offstyle="warning"   
                                <?php if(in_array($key.'-'.$sub_sub_permission, $permissions)): ?> checked <?php endif; ?>  
                                data-width="60px"
                            />
                        </td> 
                        <?php else: ?> 
                            <td>&nbsp;</td>
                        <?php endif; ?>                        
                    <?php else: ?> 
                        <td>&nbsp;</td>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                    
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       
    </tbody>
</table>
<link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet"/>
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
<script>
    $(document).ready(function(){
        var roles = <?php echo json_encode($permission_list); ?>;
        roles.forEach(function(role){
            $('#'+role+'-checked').on('change', function(){
                var list = ['index', 'create', 'update', 'destroy'];
                if($(this).is(':checked')) {
                    list.forEach(function(item) {
                        if(!$('#'+role+'-'+item).is(':checked')) {
                            $('#'+role+'-'+item).bootstrapToggle('on');
                        }
                    });
                }else {
                    list.forEach(function(item) {
                        if($('#'+role+'-'+item).is(':checked')) {
                            $('#'+role+'-'+item).bootstrapToggle('off');
                        }
                    });
                }
            })
        });
        
    });
</script>
<?php /**PATH /var/www/html/smartcm/resources/views/pages/users/show.blade.php ENDPATH**/ ?>