<?php $__env->startSection('page-header'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h4 class="m-0">Dashboard</h4>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item active">Dashboard</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        @keyframes  blink {
            0%, 100% { opacity: 1; }
            50% { opacity: 0; }
        }

        .blink {
            animation: blink 2s step-start infinite;
        }
    </style>
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>

    <?php if($remaining_days <= 14): ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card card-success card-outline">
                <div class="card-body">
                    <b class="blink" style="font-size: 24px; color: tomato;">Your registration will be expire with in <?php echo e($remaining_days); ?> days. Please renew Here</b>
                    <a class="btn btn-xs btn-outline-success" style="vertical-align: bottom; margin-left: 15px;" href="<?php echo e(route("dashboard", ["paynow" => 1])); ?>"><?php echo app('translator')->get("Pay Now"); ?></a>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['payment-create', 'student-create', 'batch-create', 'payment-index'])): ?>
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="card card-light">
                <div class="card-header">
                    <h4 class="card-title">Quick Access</h4>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                        </button>

                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                          <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment-create')): ?>
                        <div class="col-md-2 col-sm-12 p-1">
                            <a href="<?php echo e(route('payments.quick')); ?>" class="btn btn-info w-100">Quick Payment</a>
                        </div>
                      <?php endif; ?>

                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-create')): ?>
                        <div class="col-md-2 col-sm-12 p-1">
                            <a href="<?php echo e(route('students.create')); ?>" class="btn btn-success w-100">Add Student</a>
                        </div>
                      <?php endif; ?>

                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('batch-create')): ?>
                        <div class="col-md-2 col-sm-12 p-1">
                            <a href="<?php echo e(route('batch.create')); ?>" class="btn btn-primary w-100">Add Batch</a>
                        </div>
                      <?php endif; ?>

                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment-index')): ?>
                        <div class="col-md-2 col-sm-12 p-1">
                            <a href="<?php echo e(route('payments.index')); ?>" class="btn btn-info w-100">Payment List</a>
                        </div>
                      <?php endif; ?>

                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('miscellaneous-sms_buy')): ?>
                        <div class="col-md-2 col-sm-12 p-1">
                            <a href="<?php echo e(route('sms_buy')); ?>" target="_blank" class="btn btn-success w-100">Buy SMS</a>
                        </div>
                      <?php endif; ?>
                      <div class="col-md-2 col-sm-12 p-1">
                          <a target="_blank" href="<?php echo e($user_manual_link ?? "#"); ?>" class="btn btn-danger w-100">View User Manual</a>
                      </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="row">
        <div class="col-12 col-sm-6 col-md-3">
          <?php if(auth()->user()->level == 'Super Admin'): ?>
            <div class="info-box">
                <span class="info-box-icon bg-info elevation-1"><i class="fas fa-home"></i></span>
                <div class="info-box-content">
                  <span class="info-box-text"><b>Institutions</b></span>
                  <span class="info-box-number">
                    <?php echo e($total_institution); ?>

                    <small></small>
                  </span>
                </div>
            </div>
          <?php else: ?>
          <div class="info-box">
              <span class="info-box-icon bg-info elevation-1"><i class="fas fa-sms"></i></span>
              <div class="info-box-content">
                <span class="info-box-text"><b>SMS</b></span>
                  <span class="info-box-number">
                    Total SMS: <span id="total_sms"></span>
                  </span>
                  <small></small>
                </span>
              </div>
          </div>
          <?php endif; ?>
              <!-- /.info-box -->
        </div>


        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
              <span class="info-box-icon bg-primary elevation-1"><i class="fas fa-users"></i></span>
              <div class="info-box-content">
                <span class="info-box-text"><b>Students</b></span>
                <span class="info-box-number">
                  <?php echo e($total_student); ?>

                  <small></small>
                </span>
              </div>
            </div>
            <!-- /.info-box -->
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
              <span class="info-box-icon bg-success elevation-1"><i class="fas fa-users"></i></span>
              <div class="info-box-content">
                <span class="info-box-text"><b>Users</b></span>
                <span class="info-box-number">
                  <?php echo e($total_user); ?>

                  <small></small>
                </span>
              </div>
            </div>
            <!-- /.info-box -->
        </div>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
              <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-credit-card"></i></span>
              <div class="info-box-content">
                <span class="info-box-text"><b>Payments</b></span>
                <span class="info-box-number">
                  <?php echo e($total_payment); ?>

                  <small></small>
                </span>
              </div>
            </div>
            <!-- /.info-box -->
        </div>
    </div>
    <div class="row">
      <div class="col-md-8 col-sm-12">
        <!-- TABLE: LATEST Payments -->
        <div class="card card-light">
          <div class="card-header border-transparent">
            <h3 class="card-title">Latest Payments</h3>

            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse">
                <i class="fas fa-minus"></i>
              </button>
              <button type="button" class="btn btn-tool" data-card-widget="remove">
                <i class="fas fa-times"></i>
              </button>
            </div>
          </div>
          <!-- /.card-header -->
          <div class="card-body p-0">
            <div class="table-responsive">
              <table class="table m-0">
                <thead>
                <tr>
                  <th>Ref. No</th>
                  <th>Date</th>
                  <th>Student</th>
                  <th>Batch</th>
                </tr>
                </thead>
                <tbody>
                <?php if($latest_payments->isNotEmpty()): ?>
                <?php $__currentLoopData = $latest_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latest_payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($latest_payment->ref_no); ?></td>
                  <td><?php echo e(date('d,M-y', strtotime($latest_payment->payment_date))); ?></td>
                  <td><?php echo e($latest_payment->student->student_name); ?></td>
                  <td>
                    <?php echo e($latest_payment->student->batch->batch_name); ?>

                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                </tbody>
              </table>
            </div>
            <!-- /.table-responsive -->
          </div>
          <!-- /.card-body -->
          <div class="card-footer clearfix">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment-create')): ?>
            <a href="<?php echo e(route('payments.create')); ?>" class="btn btn-sm btn-info float-left">Create New Payment</a>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment-index')): ?>
            <a href="<?php echo e(route('payments.index')); ?>" class="btn btn-sm btn-dark float-right">Payment List</a>
            <?php endif; ?>
          </div>
          <!-- /.card-footer -->
        </div>
      </div>

      <div class="col-md-4 col-sm-12">
        <div class="card card-light">
          <div class="card-header">
            <h3 class="card-title">Recently Added Students</h3>

            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse">
                <i class="fas fa-minus"></i>
              </button>
              <button type="button" class="btn btn-tool" data-card-widget="remove">
                <i class="fas fa-times"></i>
              </button>
            </div>
          </div>
          <!-- /.card-header -->
          <div class="card-body p-0">
            <ul class="products-list product-list-in-card pl-2 pr-2">
              <?php if($latest_students->isNotEmpty()): ?>
              <?php $__currentLoopData = $latest_students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latest_student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li class="item">
                <div class="product-img">
                  <?php if($latest_student->user_profile): ?>
                  <img src="<?php echo e(asset('/storage/students/'.$latest_student->user_profile)); ?>" alt="Product Image" class="img-size-50 img-rounded" />
                  <?php else: ?>
                  <img src="<?php echo e(asset("/dist/img/profile_avatar.png")); ?>" alt="Product Image" class="img-size-50" />
                  <?php endif; ?>
                </div>
                <div class="product-info">
                  <a href="javascript:void(0)" class="product-title"><?php echo e($latest_student->student_name); ?>

                    <span class="badge badge-dark text-light float-right"><?php echo e($latest_student->batch->batch_name); ?></span></a>
                  <span class="product-description">
                    <i class="fa fa-calendar"></i> <?php echo e(date('d-M,y', strtotime($latest_student->admission_date))); ?>

                    <?php if($latest_student->student_contact): ?>
                    <i class="fa fa-phone"></i> <?php echo e($latest_student->student_contact); ?> (St.)
                    <?php else: ?>
                    <i class="fa fa-phone"></i> <?php echo e($latest_student->guardian_contact); ?> (Gr.)
                    <?php endif; ?>
                  </span>
                </div>
              </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
              <!-- /.item -->

            </ul>
          </div>
          <!-- /.card-body -->
          <div class="card-footer text-center">
            <a href="<?php echo e(route('students.index')); ?>" class="uppercase">View All Student</a>
          </div>
          <!-- /.card-footer -->
        </div>
      </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
    $(document).ready(function(){
       $.ajax({
           url: "<?php echo e(route('sms.balance_check')); ?>",
           method: 'GET',
           beforeSend: function(){
               $('#total_sms').text('Loading...');
           },
           success: function(data) {
               $('#total_sms').text(data);
           }
       })
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/spanmmdr/smartqb.info/resources/views/index.blade.php ENDPATH**/ ?>